/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.requests.executor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import me.gv7.woodpecker.requests.Cookie;
import me.gv7.woodpecker.requests.Header;
import me.gv7.woodpecker.requests.Headers;
import me.gv7.woodpecker.requests.RawResponse;
import me.gv7.woodpecker.requests.Request;
import me.gv7.woodpecker.requests.RequestBuilder;
import me.gv7.woodpecker.requests.body.RequestBody;
import me.gv7.woodpecker.requests.exception.RequestsException;
import me.gv7.woodpecker.requests.exception.TooManyRedirectsException;
import me.gv7.woodpecker.requests.executor.CookieJar;
import me.gv7.woodpecker.requests.executor.HttpExecutor;
import me.gv7.woodpecker.requests.executor.NopCookieJar;
import me.gv7.woodpecker.requests.utils.Cookies;
import me.gv7.woodpecker.requests.utils.NopHostnameVerifier;
import me.gv7.woodpecker.requests.utils.SSLSocketFactories;
import me.gv7.woodpecker.requests.utils.URLUtils;
import net.dongliu.commons.io.InputStreams;
import org.checkerframework.checker.nullness.qual.Nullable;

class URLConnectionExecutor
implements HttpExecutor {
    URLConnectionExecutor() {
    }

    @Override
    public RawResponse proceed(Request request) {
        RawResponse response = this.doRequest(request);
        int statusCode = response.statusCode();
        if (!request.followRedirect() || !URLConnectionExecutor.isRedirect(statusCode)) {
            return response;
        }
        response.discardBody();
        int redirectTimes = 0;
        int maxRedirectTimes = request.maxRedirectCount();
        URL redirectUrl = request.url();
        while (redirectTimes++ < maxRedirectTimes) {
            RequestBuilder builder;
            String location = response.getHeader("Location");
            if (location == null) {
                throw new RequestsException("Redirect location not found");
            }
            try {
                redirectUrl = new URL(redirectUrl, location);
            }
            catch (MalformedURLException e) {
                throw new RequestsException("Resolve redirect url error, location: " + location, e);
            }
            String method = request.method();
            RequestBody<?> body = request.body();
            if (statusCode == 301 || statusCode == 302 || statusCode == 303) {
                method = "GET";
                body = null;
            }
            if (!URLConnectionExecutor.isRedirect((response = (builder = request.toBuilder().method(method).url(redirectUrl).followRedirect(false).body(body)).send()).statusCode())) {
                return response;
            }
            response.discardBody();
        }
        throw new TooManyRedirectsException(maxRedirectTimes);
    }

    private static boolean isRedirect(int status) {
        return status == 300 || status == 301 || status == 302 || status == 303 || status == 307 || status == 308;
    }

    private RawResponse doRequest(Request request) {
        HttpURLConnection conn;
        Charset charset = request.charset();
        URL url = URLUtils.joinUrl(request.url(), URLUtils.toStringParameters(request.params()), charset);
        @Nullable RequestBody<?> body = request.body();
        CookieJar cookieJar = request.sessionContext() != null ? request.sessionContext().cookieJar() : NopCookieJar.instance;
        @Nullable Proxy proxy = request.proxy();
        if (proxy == null) {
            proxy = Proxy.NO_PROXY;
        }
        try {
            conn = (HttpURLConnection)url.openConnection(proxy);
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        conn.setUseCaches(false);
        if (conn instanceof HttpsURLConnection) {
            SSLSocketFactory ssf;
            HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
            if (!request.verify()) {
                ssf = SSLSocketFactories.getTrustAllSSLSocketFactory();
                httpsConn.setSSLSocketFactory(ssf);
                httpsConn.setHostnameVerifier(NopHostnameVerifier.getInstance());
            } else if (request.keyStore() != null) {
                ssf = SSLSocketFactories.getCustomTrustSSLSocketFactory(request.keyStore());
                httpsConn.setSSLSocketFactory(ssf);
            }
        }
        try {
            conn.setRequestMethod(request.method());
        }
        catch (ProtocolException e) {
            throw new RequestsException(e);
        }
        conn.setReadTimeout(request.socksTimeout());
        conn.setConnectTimeout(request.connectTimeout());
        conn.setInstanceFollowRedirects(false);
        if (body != null) {
            conn.setDoOutput(true);
            String contentType = body.contentType();
            if (contentType != null) {
                if (body.includeCharset()) {
                    contentType = contentType + "; charset=" + request.charset().name().toLowerCase();
                }
                conn.setRequestProperty("Content-Type", contentType);
            }
        }
        if (!request.userAgent().isEmpty()) {
            conn.setRequestProperty("User-Agent", request.userAgent());
        }
        if (request.acceptCompress()) {
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
        }
        if (request.basicAuth() != null) {
            conn.setRequestProperty("Authorization", request.basicAuth().encode());
        }
        List<Cookie> sessionCookies = cookieJar.getCookies(url);
        if (!request.cookies().isEmpty() || !sessionCookies.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, ?> entry : request.cookies()) {
                sb.append(entry.getKey()).append("=").append(String.valueOf(entry.getValue())).append("; ");
            }
            for (Cookie cookie : sessionCookies) {
                sb.append(cookie.name()).append("=").append((String)cookie.value()).append("; ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
                String string = sb.toString();
                conn.setRequestProperty("Cookie", string);
            }
        }
        for (Map.Entry entry : request.headers()) {
            conn.setRequestProperty((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        if (!request.keepAlive()) {
            conn.setRequestProperty("Connection", "close");
        }
        try {
            conn.connect();
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        try {
            if (body != null) {
                this.sendBody(body, conn, charset);
            }
            return this.getResponse(url, conn, cookieJar, request.method());
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            conn.disconnect();
        }
    }

    private RawResponse getResponse(URL url, HttpURLConnection conn, CookieJar cookieJar, String method) throws IOException {
        InputStream input;
        int status = conn.getResponseCode();
        String host = url.getHost().toLowerCase();
        String statusLine = null;
        ArrayList<Header> headerList = new ArrayList<Header>();
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        int index = 0;
        while (true) {
            Cookie c;
            String key = conn.getHeaderFieldKey(index);
            String value = conn.getHeaderField(index);
            if (value == null) break;
            ++index;
            if (key == null) {
                statusLine = value;
                continue;
            }
            headerList.add(new Header(key, value));
            if (!key.equalsIgnoreCase("Set-Cookie") || (c = Cookies.parseCookie(value, host, Cookies.calculatePath(url.getPath()))) == null) continue;
            cookies.add(c);
        }
        Headers headers = new Headers(headerList);
        try {
            input = conn.getInputStream();
        }
        catch (IOException e) {
            input = conn.getErrorStream();
        }
        if (input == null) {
            input = InputStreams.empty();
        }
        cookieJar.storeCookies(cookies);
        return new RawResponse(method, url.toExternalForm(), status, statusLine == null ? "" : statusLine, cookies, headers, input, conn);
    }

    private void sendBody(RequestBody body, HttpURLConnection conn, Charset requestCharset) {
        try (OutputStream os = conn.getOutputStream();){
            body.writeBody(os, requestCharset);
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
    }

    static {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        System.setProperty("http.keepAlive", "true");
        System.setProperty("http.maxConnections", "100");
    }
}

