/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.requests.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.gv7.woodpecker.requests.json.JsonProcessor;

public class GsonProcessor
implements JsonProcessor {
    private static final Logger logger = Logger.getLogger(GsonProcessor.class.getName());
    private final Gson gson;

    public GsonProcessor() {
        this(GsonProcessor.getDefaultGson());
    }

    private static Gson getDefaultGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping();
        GsonProcessor.registerAllTypeFactories(gsonBuilder);
        return gsonBuilder.create();
    }

    private static void registerAllTypeFactories(GsonBuilder gsonBuilder) {
        ServiceLoader<TypeAdapterFactory> loader = ServiceLoader.load(TypeAdapterFactory.class);
        for (TypeAdapterFactory typeFactory : loader) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Add gson type factory: " + typeFactory.getClass().getName());
            }
            gsonBuilder.registerTypeAdapterFactory(typeFactory);
        }
    }

    public GsonProcessor(Gson gson) {
        this.gson = gson;
    }

    @Override
    public void marshal(Writer writer, Object value) {
        this.gson.toJson(value, (Appendable)writer);
    }

    @Override
    public <T> T unmarshal(InputStream inputStream, Charset charset, Type type) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, charset);){
            Object object = this.gson.fromJson((Reader)reader, type);
            return (T)object;
        }
    }
}

