/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.diablo.common.model;

import java.io.Serializable;

public class JsonResponse
implements Serializable {
    private static final long serialVersionUID = -4761871227325502579L;
    public static final Integer OK = 200;
    public static final Integer REDIRECT = 302;
    public static final Integer ERR = 500;
    public static final JsonResponse NEED_LOGIN = JsonResponse.notOk(403, "\u7528\u6237\u672a\u767b\u5f55");
    public static final JsonResponse AUTH_FAIL = JsonResponse.notOk(401, "\u8ba4\u8bc1\u5931\u8d25");
    public static final JsonResponse PARAM_MISSING = JsonResponse.notOk(400, "\u53c2\u6570\u7f3a\u5931");
    public static final JsonResponse SERVER_ERR = JsonResponse.notOk(ERR, "\u670d\u52a1\u5668\u5f02\u5e38");
    private Integer status;
    private Object err;
    private Object data;

    public static JsonResponse ok() {
        JsonResponse r = new JsonResponse();
        r.status = OK;
        return r;
    }

    public static JsonResponse ok(Object data) {
        JsonResponse r = new JsonResponse();
        r.status = OK;
        r.data = data;
        return r;
    }

    public static JsonResponse notOk(Object err) {
        JsonResponse r = new JsonResponse();
        r.status = ERR;
        r.err = err;
        return r;
    }

    public static JsonResponse notOk(Integer status, Object err) {
        JsonResponse r = new JsonResponse();
        r.status = status;
        r.err = err;
        return r;
    }

    public static JsonResponse redirect(String url) {
        JsonResponse r = new JsonResponse();
        r.status = REDIRECT;
        r.data = url;
        return r;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Object getErr() {
        return this.err;
    }

    public void setErr(Object err) {
        this.err = err;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Boolean isSuccess() {
        return this.status.intValue() == OK.intValue();
    }

    public String toString() {
        return "JsonResponse{status=" + this.status + ", err=" + this.err + ", data=" + this.data + '}';
    }
}

