/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wechat.core;

import com.fasterxml.jackson.databind.JavaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.hao0.common.json.Jsons;
import me.hao0.common.util.Preconditions;
import me.hao0.wechat.core.AsyncFunction;
import me.hao0.wechat.core.Callback;
import me.hao0.wechat.core.Component;
import me.hao0.wechat.model.menu.Menu;

public final class Menus
extends Component {
    private static final String GET = "https://api.weixin.qq.com/cgi-bin/menu/get?access_token=";
    private static final String CREATE = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=";
    private static final String DELETE = "https://api.weixin.qq.com/cgi-bin/menu/delete?access_token=";
    private static final JavaType ARRAY_LIST_MENU_TYPE = Jsons.DEFAULT.createCollectionType(ArrayList.class, new Class[]{Menu.class});

    Menus() {
    }

    public List<Menu> get() {
        return this.get(this.loadAccessToken());
    }

    public void get(Callback<List<Menu>> cb) {
        this.get(this.loadAccessToken(), cb);
    }

    public void get(final String accessToken, Callback<List<Menu>> cb) {
        this.doAsync(new AsyncFunction<List<Menu>>(cb){

            @Override
            public List<Menu> execute() {
                return Menus.this.get(accessToken);
            }
        });
    }

    public List<Menu> get(String accessToken) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        String url = GET + accessToken;
        Map<String, Object> resp = this.doGet(url);
        String jsonMenu = Jsons.DEFAULT.toJson(((Map)resp.get("menu")).get("button"));
        return (List)Jsons.EXCLUDE_DEFAULT.fromJson(jsonMenu, ARRAY_LIST_MENU_TYPE);
    }

    public Boolean create(String jsonMenu) {
        return this.create(this.loadAccessToken(), jsonMenu);
    }

    public void create(final String accessToken, final String jsonMenu, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() {
                return Menus.this.create(accessToken, jsonMenu);
            }
        });
    }

    public void create(String jsonMenu, Callback<Boolean> cb) {
        this.create(this.loadAccessToken(), jsonMenu, cb);
    }

    public Boolean create(String accessToken, String jsonMenu) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        Preconditions.checkNotNullAndEmpty((String)jsonMenu, (String)"jsonMenu");
        String url = CREATE + accessToken;
        this.doPost(url, jsonMenu);
        return Boolean.TRUE;
    }

    public Boolean delete() {
        return this.delete(this.loadAccessToken());
    }

    public void delete(Callback<Boolean> cb) {
        this.delete(this.loadAccessToken(), cb);
    }

    public void delete(final String accessToken, Callback<Boolean> cb) {
        this.doAsync(new AsyncFunction<Boolean>(cb){

            @Override
            public Boolean execute() {
                return Menus.this.delete(accessToken);
            }
        });
    }

    public Boolean delete(String accessToken) {
        Preconditions.checkNotNullAndEmpty((String)accessToken, (String)"accessToken");
        String url = DELETE + accessToken;
        this.doGet(url);
        return Boolean.TRUE;
    }
}

