/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wechat.model.message.receive;

import java.util.Objects;
import me.hao0.wechat.exception.EventException;

public enum RecvMessageType {
    TEXT("text", "\u6587\u672c\u6d88\u606f"),
    IMAGE("image", "\u56fe\u7247\u6d88\u606f"),
    VOICE("voice", "\u8bed\u97f3\u6d88\u606f"),
    VIDEO("video", "\u89c6\u9891\u6d88\u606f"),
    SHORT_VIDEO("shortvideo", "\u5c0f\u89c6\u9891\u6d88\u606f"),
    LOCATION("location", "\u5730\u7406\u4f4d\u7f6e\u4fe1\u606f"),
    LINK("link", "\u94fe\u63a5\u4fe1\u606f"),
    EVENT("event", "\u4e8b\u4ef6\u6d88\u606f");

    private String value;
    private String desc;

    private RecvMessageType(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public static RecvMessageType from(String type) {
        for (RecvMessageType t : RecvMessageType.values()) {
            if (!Objects.equals(t.value(), type)) continue;
            return t;
        }
        throw new EventException("unknown message type");
    }

    public String toString() {
        return "RecvMessageType{value='" + this.value + '\'' + ", desc='" + this.desc + '\'' + '}';
    }
}

