/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wechat.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.hao0.wechat.exception.XmlException;

public class XmlWriters {
    List<E> es = new ArrayList<E>();

    private XmlWriters() {
    }

    public static XmlWriters create() {
        return new XmlWriters();
    }

    public XmlWriters element(String name, String text) {
        TextE e = new TextE(name, (Serializable)((Object)text));
        this.es.add(e);
        return this;
    }

    public XmlWriters element(String name, Number number) {
        NumberE e = new NumberE(name, number);
        this.es.add(e);
        return this;
    }

    public XmlWriters element(String parentName, String childName, String childText) {
        return this.element(parentName, new TextE(childName, (Serializable)((Object)childText)));
    }

    public XmlWriters element(String parentName, String childName, Number childNumber) {
        return this.element(parentName, new NumberE(childName, childNumber));
    }

    public XmlWriters element(String parentName, Object ... childPairs) {
        if (childPairs.length % 2 != 0) {
            throw new XmlException("var args's length must % 2 = 0");
        }
        TextE parent = new TextE(parentName, null);
        ArrayList<E> children = new ArrayList<E>();
        for (int i = 0; i < childPairs.length; i += 2) {
            E child = childPairs[i + 1] instanceof Number ? new NumberE((String)childPairs[i], (Serializable)childPairs[i + 1]) : new TextE((String)childPairs[i], (Serializable)childPairs[i + 1]);
            children.add(child);
        }
        parent.children = children;
        this.es.add(parent);
        return this;
    }

    public XmlWriters element(String parentName, E child) {
        TextE e = new TextE(parentName, null);
        e.children = Arrays.asList(child);
        this.es.add(e);
        return this;
    }

    public XmlWriters element(String parentName, List<E> children) {
        TextE e = new TextE(parentName, null);
        e.children = children;
        this.es.add(e);
        return this;
    }

    public E newElement(String parentName, Object ... childPairs) {
        TextE parent = new TextE(parentName, null);
        ArrayList<E> children = new ArrayList<E>();
        for (int i = 0; i < childPairs.length; i += 2) {
            E child = childPairs[i + 1] instanceof Number ? new NumberE((String)childPairs[i], (Serializable)childPairs[i + 1]) : new TextE((String)childPairs[i], (Serializable)childPairs[i + 1]);
            children.add(child);
        }
        parent.children = children;
        return parent;
    }

    public String build() {
        return this.buildElements();
    }

    private String buildElements() {
        StringBuilder xml = new StringBuilder();
        xml.append("<xml>");
        if (this.es != null && this.es.size() > 0) {
            for (E e : this.es) {
                xml.append(e.render());
            }
        }
        xml.append("</xml>");
        return xml.toString();
    }

    public static final class NumberE
    extends E {
        public NumberE(String name, Serializable content) {
            super(name, content);
        }

        @Override
        protected String render() {
            StringBuilder content = new StringBuilder();
            content.append("<").append(this.name).append(">").append(this.text).append("</").append(this.name).append(">");
            return content.toString();
        }
    }

    public static final class TextE
    extends E {
        public TextE(String name, Serializable content) {
            super(name, content);
        }

        @Override
        protected String render() {
            StringBuilder content = new StringBuilder();
            content.append("<").append(this.name).append(">");
            if (this.text != null) {
                content.append("<![CDATA[").append(this.text).append("]]>");
            }
            if (this.children != null && this.children.size() > 0) {
                for (E child : this.children) {
                    content.append(child.render());
                }
            }
            content.append("</").append(this.name).append(">");
            return content.toString();
        }
    }

    public static abstract class E {
        String name;
        Object text;
        List<E> children;

        public E(String name, Object text) {
            this.name = name;
            this.text = text;
        }

        protected abstract String render();
    }
}

