/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.wepay.demo.support;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.PostConstruct;
import me.hao0.common.date.Dates;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.core.WepayBuilder;
import me.hao0.wepay.model.pay.QrPayRequest;
import me.hao0.wepay.model.refund.RefundApplyRequest;
import me.hao0.wepay.model.refund.RefundApplyResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WepaySupport {
    @Value(value="${appId}")
    private String appId;
    @Value(value="${appKey}")
    private String appKey;
    @Value(value="${mchId}")
    private String mchId;
    @Value(value="${payNotifyUrl}")
    private String payNotifyUrl;
    private Wepay wepay;

    @PostConstruct
    public void initWepay() {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("cert.p12");){
            byte[] certs = ByteStreams.toByteArray((InputStream)in);
            this.wepay = WepayBuilder.newBuilder((String)this.appId, (String)this.appKey, (String)this.mchId).certPasswd(this.mchId).certs(certs).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String qrPay(String orderNumber) {
        QrPayRequest request = new QrPayRequest();
        request.setBody("\u6d4b\u8bd5\u8ba2\u5355");
        request.setClientId("127.0.0.1");
        request.setTotalFee(Integer.valueOf(1));
        request.setNotifyUrl(this.payNotifyUrl);
        request.setOutTradeNo(orderNumber);
        request.setTimeStart(Dates.now((String)"yyyyMMddHHmmss"));
        return this.wepay.pay().qrPay(request).getCodeUrl();
    }

    public Boolean verifySign(Map<String, ?> params) {
        return this.wepay.notifies().verifySign(params);
    }

    public String notifyOk() {
        return this.wepay.notifies().ok();
    }

    public String notifyNotOk(String errMsg) {
        return this.wepay.notifies().notOk(errMsg);
    }

    public RefundApplyResponse refundApply(String orderNumber) {
        RefundApplyRequest req = new RefundApplyRequest();
        req.setOutTradeNo(orderNumber);
        req.setOutRefundNo(orderNumber);
        req.setTotalFee(Integer.valueOf(1));
        req.setRefundFee(Integer.valueOf(1));
        req.setOpUserId(this.wepay.getMchId());
        return this.wepay.refund().apply(req);
    }
}

