/*
 * Decompiled with CFR 0.152.
 */
package me.him188.kotlin.dynamic.delegation.compiler.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import me.him188.kotlin.dynamic.delegation.compiler.backend.DDFqNames;
import me.him188.kotlin.dynamic.delegation.compiler.diagnostics.DynamicDelegationCallChecker;
import me.him188.kotlin.dynamic.delegation.compiler.diagnostics.DynamicDelegationCallCheckerKt;
import me.him188.kotlin.dynamic.delegation.compiler.diagnostics.Errors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/him188/kotlin/dynamic/delegation/compiler/diagnostics/DynamicDelegationCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "isIr", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "", "(Lkotlin/jvm/functions/Function1;)V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkPropertyReceiver", "kotlin-dynamic-delegation-compiler"})
public final class DynamicDelegationCallChecker
implements CallChecker {
    @NotNull
    private final Function1<PsiElement, Boolean> isIr;

    public DynamicDelegationCallChecker(@NotNull Function1<? super PsiElement, Boolean> isIr) {
        Intrinsics.checkNotNullParameter(isIr, (String)"isIr");
        this.isIr = isIr;
    }

    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"resolvedCall.resultingDescriptor");
        FqName fqn = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor));
        if (Intrinsics.areEqual((Object)fqn, (Object)DDFqNames.INSTANCE.getDYNAMIC_DELEGATION())) {
            if (!((Boolean)this.isIr.invoke((Object)reportOn)).booleanValue()) {
                context.getTrace().report((Diagnostic)Errors.DYNAMIC_DELEGATION_REQUIRES_IR.on(reportOn));
                return;
            }
            KtElement ktElement = resolvedCall.getCall().getCallElement();
            Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"resolvedCall.call.callElement");
            KtElement element = ktElement;
            if (!(SequencesKt.firstOrNull((Sequence)SequencesKt.filterNot((Sequence)PsiUtilsKt.getParents((PsiElement)((PsiElement)element)), (Function1)check.1.INSTANCE)) instanceof KtDelegatedSuperTypeEntry)) {
                context.getTrace().report((Diagnostic)Errors.DYNAMIC_DELEGATION_NOT_ALLOWED.on(reportOn));
                return;
            }
            this.checkPropertyReceiver(context, resolvedCall, reportOn);
        }
    }

    private final void checkPropertyReceiver(CallCheckerContext context, ResolvedCall<?> resolvedCall, PsiElement reportOn) {
        boolean bl;
        ValueArgument valueArgument;
        ExpressionValueArgument argument;
        SimpleType containingClassType;
        block15: {
            block14: {
                DeclarationDescriptor declarationDescriptor;
                KtElement ktElement = resolvedCall.getCall().getCallElement();
                Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"resolvedCall.call.callElement");
                KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)ktElement);
                if (ktClass != null) {
                    KtExpression ktExpression = (KtExpression)ktClass;
                    BindingContext bindingContext = context.getTrace().getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
                    declarationDescriptor = DynamicDelegationCallCheckerKt.getDescriptor(ktExpression, bindingContext);
                } else {
                    declarationDescriptor = null;
                }
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
                ClassDescriptor classDescriptor = declarationDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor2 : null;
                if (classDescriptor == null) {
                    return;
                }
                ClassDescriptor containingClass = classDescriptor;
                SimpleType simpleType = containingClass.getDefaultType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"containingClass.defaultType");
                containingClassType = simpleType;
                List list = resolvedCall.getValueArgumentsByIndex();
                ResolvedValueArgument resolvedValueArgument = list != null ? (ResolvedValueArgument)CollectionsKt.firstOrNull((List)list) : null;
                ExpressionValueArgument expressionValueArgument = resolvedValueArgument instanceof ExpressionValueArgument ? (ExpressionValueArgument)resolvedValueArgument : null;
                if (expressionValueArgument == null) {
                    return;
                }
                argument = expressionValueArgument;
                valueArgument = argument.getValueArgument();
                if (valueArgument == null || (valueArgument = valueArgument.getArgumentExpression()) == null) break block14;
                BindingContext bindingContext = context.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
                if ((valueArgument = CallUtilKt.getType((KtExpression)valueArgument, (BindingContext)bindingContext)) != null) break block15;
            }
            return;
        }
        ValueArgument argumentType = valueArgument;
        ClassifierDescriptor classifierDescriptor = argumentType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null && (classifierDescriptor = classifierDescriptor.getDefaultType()) != null) {
            KotlinType kotlinType = (KotlinType)classifierDescriptor;
            SimpleType simpleType = context.getModuleDescriptor().getBuiltIns().getKProperty1().getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"context.moduleDescriptor\u2026ns.kProperty1.defaultType");
            bl = TypeUtilsKt.isSubtypeOf((KotlinType)kotlinType, (KotlinType)((KotlinType)simpleType));
        } else {
            bl = false;
        }
        if (!bl) {
            return;
        }
        TypeProjection typeProjection = (TypeProjection)CollectionsKt.firstOrNull((List)argumentType.getArguments());
        if (typeProjection == null || (typeProjection = typeProjection.getType()) == null) {
            return;
        }
        TypeProjection referenceReceiverType = typeProjection;
        if (!Intrinsics.areEqual((Object)containingClassType, (Object)referenceReceiverType) && !TypeUtilsKt.isSubtypeOf((KotlinType)((KotlinType)containingClassType), (KotlinType)referenceReceiverType)) {
            BindingTrace bindingTrace = context.getTrace();
            PsiElement psiElement = argument.getValueArgument();
            if (psiElement == null || (psiElement = psiElement.getArgumentExpression()) == null || (psiElement = psiElement.getChildren()) == null || (psiElement = (PsiElement)ArraysKt.firstOrNull((Object[])psiElement)) == null) {
                psiElement = reportOn;
            }
            KtElement ktElement = resolvedCall.getCall().getCallElement();
            Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"resolvedCall.call.callElement");
            KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)ktElement);
            if (ktClass == null || (ktClass = ktClass.getNameAsSafeName()) == null) {
                return;
            }
            bindingTrace.report((Diagnostic)Errors.INCOMPATIBLE_PROPERTY_RECEIVER.on(psiElement, (Object)ktClass));
            return;
        }
    }
}

