/*
 * Decompiled with CFR 0.152.
 */
package me.him188.kotlin.jvm.blocking.bridge.compiler.backend.ir;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import me.him188.kotlin.jvm.blocking.bridge.compiler.backend.ir.RuntimeIntrinsics;
import me.him188.kotlin.jvm.blocking.bridge.compiler.backend.resolve.GeneratedBlockingBridgeStubForResolution;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLoweringKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\t\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\f\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\r\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0007\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0011H\u0000\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\u0010*\u00020\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0013"}, d2={"isAbstract", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "isFinal", "isOpen", "findOverriddenDescriptorsHierarchically", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "filter", "Lkotlin/Function1;", "isGeneratedBlockingBridgeStub", "isJvmBlockingBridge", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isUserDeclaredFunction", "jvmBlockingBridgeAnnotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "jvmBlockingBridgeAnnotationOnContainingClass", "kotlin-jvm-blocking-bridge-compiler"})
@JvmName(name="JvmBlockingBridgeUtils")
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\nme/him188/kotlin/jvm/blocking/bridge/compiler/backend/ir/JvmBlockingBridgeUtils\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,75:1\n15#2,2:76\n*S KotlinDebug\n*F\n+ 1 util.kt\nme/him188/kotlin/jvm/blocking/bridge/compiler/backend/ir/JvmBlockingBridgeUtils\n*L\n64#1:76,2\n*E\n"})
public final class JvmBlockingBridgeUtils {
    public static final boolean isJvmBlockingBridge(@NotNull IrClass $this$isJvmBlockingBridge) {
        Intrinsics.checkNotNullParameter($this$isJvmBlockingBridge, "<this>");
        FqName fqName = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)$this$isJvmBlockingBridge.getSymbol().getOwner()));
        return Intrinsics.areEqual(fqName != null ? fqName.asString() : null, RuntimeIntrinsics.INSTANCE.getJvmBlockingBridgeFqName().asString());
    }

    public static final boolean isJvmBlockingBridge(@NotNull FunctionDescriptor $this$isJvmBlockingBridge) {
        Intrinsics.checkNotNullParameter($this$isJvmBlockingBridge, "<this>");
        return $this$isJvmBlockingBridge.getAnnotations().hasAnnotation(RuntimeIntrinsics.INSTANCE.getJvmBlockingBridgeFqName());
    }

    public static final boolean isJvmBlockingBridge(@NotNull IrFunction $this$isJvmBlockingBridge) {
        Intrinsics.checkNotNullParameter($this$isJvmBlockingBridge, "<this>");
        return AdditionalIrUtilsKt.hasAnnotation((List)$this$isJvmBlockingBridge.getAnnotations(), (FqName)RuntimeIntrinsics.INSTANCE.getJvmBlockingBridgeFqName());
    }

    public static final boolean isGeneratedBlockingBridgeStub(@NotNull IrFunction $this$isGeneratedBlockingBridgeStub) {
        Intrinsics.checkNotNullParameter($this$isGeneratedBlockingBridgeStub, "<this>");
        return Intrinsics.areEqual($this$isGeneratedBlockingBridgeStub.getDescriptor().getUserData((CallableDescriptor.UserDataKey)GeneratedBlockingBridgeStubForResolution.INSTANCE), true);
    }

    public static final boolean isUserDeclaredFunction(@NotNull IrSimpleFunction $this$isUserDeclaredFunction) {
        Intrinsics.checkNotNullParameter($this$isUserDeclaredFunction, "<this>");
        return JvmIrUtilsKt.getPsiElement((IrDeclaration)((IrDeclaration)IrUtilsKt.getOriginalFunction((IrFunction)((IrFunction)$this$isUserDeclaredFunction)))) != null;
    }

    @Nullable
    public static final IrSimpleFunction findOverriddenDescriptorsHierarchically(@NotNull IrSimpleFunction $this$findOverriddenDescriptorsHierarchically, @NotNull Function1<? super IrSimpleFunction, Boolean> filter) {
        Intrinsics.checkNotNullParameter($this$findOverriddenDescriptorsHierarchically, "<this>");
        Intrinsics.checkNotNullParameter(filter, "filter");
        for (IrSimpleFunction override : IrUtilsKt.allOverridden((IrSimpleFunction)$this$findOverriddenDescriptorsHierarchically, (boolean)false)) {
            IrSimpleFunction find;
            if (filter.invoke((IrSimpleFunction)override).booleanValue()) {
                return override;
            }
            IrSimpleFunction irSimpleFunction = find = JvmBlockingBridgeUtils.findOverriddenDescriptorsHierarchically(override, filter);
            if (irSimpleFunction == null) continue;
            return irSimpleFunction;
        }
        return null;
    }

    @Nullable
    public static final IrConstructorCall jvmBlockingBridgeAnnotation(@NotNull IrAnnotationContainer $this$jvmBlockingBridgeAnnotation) {
        Intrinsics.checkNotNullParameter($this$jvmBlockingBridgeAnnotation, "<this>");
        return AdditionalIrUtilsKt.findAnnotation((List)$this$jvmBlockingBridgeAnnotation.getAnnotations(), (FqName)RuntimeIntrinsics.INSTANCE.getJvmBlockingBridgeFqName());
    }

    @Nullable
    public static final IrConstructorCall jvmBlockingBridgeAnnotationOnContainingClass(@NotNull IrFunction $this$jvmBlockingBridgeAnnotationOnContainingClass) {
        IrConstructorCall annotation;
        Intrinsics.checkNotNullParameter($this$jvmBlockingBridgeAnnotationOnContainingClass, "<this>");
        IrDeclarationParent containingClass = $this$jvmBlockingBridgeAnnotationOnContainingClass.getParent();
        if (containingClass instanceof IrAnnotationContainer && (annotation = AdditionalIrUtilsKt.findAnnotation((List)((IrAnnotationContainer)containingClass).getAnnotations(), (FqName)RuntimeIntrinsics.INSTANCE.getJvmBlockingBridgeFqName())) != null) {
            return annotation;
        }
        if (containingClass instanceof IrClass) {
            IrConstructorCall annotation2;
            IrFile file;
            Object object;
            Object v0;
            block4: {
                Sequence $this$firstIsInstanceOrNull$iv = LocalDeclarationsLoweringKt.getParents((IrDeclaration)((IrDeclaration)containingClass));
                boolean $i$f$firstIsInstanceOrNull = false;
                Iterator iterator2 = $this$firstIsInstanceOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    if (!(element$iv instanceof IrFile)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            IrConstructorCall irConstructorCall = (object = (file = (IrFile)v0)) != null && (object = object.getAnnotations()) != null ? AdditionalIrUtilsKt.findAnnotation((List)object, (FqName)RuntimeIntrinsics.INSTANCE.getJvmBlockingBridgeFqName()) : (annotation2 = null);
            if (annotation2 != null) {
                return annotation2;
            }
        }
        return null;
    }

    public static final boolean isFinal(@NotNull IrFunction $this$isFinal) {
        Intrinsics.checkNotNullParameter($this$isFinal, "<this>");
        return $this$isFinal instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isFinal).getModality() == Modality.FINAL;
    }

    public static final boolean isOpen(@NotNull IrFunction $this$isOpen) {
        Intrinsics.checkNotNullParameter($this$isOpen, "<this>");
        return $this$isOpen instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isOpen).getModality() == Modality.OPEN;
    }

    public static final boolean isAbstract(@NotNull IrFunction $this$isAbstract) {
        Intrinsics.checkNotNullParameter($this$isAbstract, "<this>");
        return $this$isAbstract instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isAbstract).getModality() == Modality.ABSTRACT;
    }
}

