/*
 * Decompiled with CFR 0.152.
 */
package me.him188.kotlin.jvm.blocking.bridge.compiler.backend.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.him188.kotlin.jvm.blocking.bridge.compiler.backend.ir.AnalyzeCapabilityForGeneratingBridgesKt;
import me.him188.kotlin.jvm.blocking.bridge.compiler.backend.ir.GeneratorKt;
import me.him188.kotlin.jvm.blocking.bridge.compiler.backend.ir.JvmBlockingBridgeUtils;
import me.him188.kotlin.jvm.blocking.bridge.compiler.backend.resolve.BlockingBridgeAnalyzeResult;
import me.him188.kotlin.jvm.blocking.bridge.compiler.extensions.IBridgeConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a-\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\u0004\u0018\u0001H\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\u0005\u001a\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"followedBy", "", "T", "list", "", "(Ljava/lang/Object;Ljava/util/Collection;)Ljava/util/List;", "transformFlat", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "context", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "ext", "Lme/him188/kotlin/jvm/blocking/bridge/compiler/extensions/IBridgeConfiguration;", "kotlin-jvm-blocking-bridge-compiler"})
public final class LoweringPassesKt {
    @NotNull
    public static final List<IrDeclaration> transformFlat(@NotNull IrDeclaration $this$transformFlat, @NotNull IrPluginContext context, @NotNull IBridgeConfiguration ext) {
        Intrinsics.checkNotNullParameter($this$transformFlat, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(ext, "ext");
        IrDeclaration declaration = $this$transformFlat;
        if (declaration instanceof IrSimpleFunction) {
            if (JvmBlockingBridgeUtils.isGeneratedBlockingBridgeStub((IrFunction)declaration)) {
                return CollectionsKt.emptyList();
            }
            BlockingBridgeAnalyzeResult capability = AnalyzeCapabilityForGeneratingBridgesKt.analyzeCapabilityForGeneratingBridges((IrFunction)declaration, ext);
            Diagnostic diagnostic = capability.createDiagnostic();
            if (diagnostic != null) {
                Diagnostic diagnostic2 = diagnostic;
                boolean bl = false;
                DiagnosticSink.THROW_EXCEPTION.report(diagnostic2);
            }
            if (capability.getShouldGenerate()) {
                return LoweringPassesKt.followedBy(declaration, (Collection)GeneratorKt.generateJvmBlockingBridges(context, (IrFunction)declaration));
            }
        }
        return CollectionsKt.listOf(declaration);
    }

    @NotNull
    public static final <T> List<T> followedBy(@Nullable T $this$followedBy, @NotNull Collection<? extends T> list) {
        Intrinsics.checkNotNullParameter(list, "list");
        if ($this$followedBy == null) {
            return CollectionsKt.toList((Iterable)list);
        }
        ArrayList<T> arrayList = new ArrayList<T>(list.size() + 1);
        arrayList.add($this$followedBy);
        arrayList.addAll(list);
        return arrayList;
    }
}

