/*
 * Decompiled with CFR 0.152.
 */
package me.him188.kotlin.jvm.blocking.bridge.compiler.diagnostic;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.him188.kotlin.jvm.blocking.bridge.compiler.backend.resolve.AnalyzeCapabilityForGeneratingBridgesKt;
import me.him188.kotlin.jvm.blocking.bridge.compiler.backend.resolve.AnalyzingKt;
import me.him188.kotlin.jvm.blocking.bridge.compiler.backend.resolve.BlockingBridgeAnalyzeResult;
import me.him188.kotlin.jvm.blocking.bridge.compiler.backend.resolve.HasJvmBlockingBridgeAnnotation;
import me.him188.kotlin.jvm.blocking.bridge.compiler.backend.resolve.UtilKt;
import me.him188.kotlin.jvm.blocking.bridge.compiler.diagnostic.BlockingBridgeErrors;
import me.him188.kotlin.jvm.blocking.bridge.compiler.extensions.IBridgeConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lme/him188/kotlin/jvm/blocking/bridge/compiler/diagnostic/BlockingBridgeDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "ext", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lme/him188/kotlin/jvm/blocking/bridge/compiler/extensions/IBridgeConfiguration;", "(Lkotlin/jvm/functions/Function1;)V", "check", "", "declaration", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkApplicability", "Lme/him188/kotlin/jvm/blocking/bridge/compiler/diagnostic/BlockingBridgeDeclarationChecker$CheckResult;", "checkJvmSynthetic", "isPluginEnabled", "", "CheckResult", "Companion", "kotlin-jvm-blocking-bridge-compiler"})
@SourceDebugExtension(value={"SMAP\nBlockingBridgeDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockingBridgeDeclarationChecker.kt\nme/him188/kotlin/jvm/blocking/bridge/compiler/diagnostic/BlockingBridgeDeclarationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public class BlockingBridgeDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<KtDeclaration, IBridgeConfiguration> ext;
    @NotNull
    private static final FqName JVM_SYNTHETIC = new FqName("kotlin.jvm.JvmSynthetic");

    public BlockingBridgeDeclarationChecker(@NotNull Function1<? super KtDeclaration, ? extends IBridgeConfiguration> ext) {
        Intrinsics.checkNotNullParameter(ext, (String)"ext");
        this.ext = ext;
    }

    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KtDeclaration ktDeclaration = declaration;
        if (ktDeclaration instanceof KtClass) {
            PsiElement psiElement = AnalyzingKt.jvmBlockingBridgeAnnotationPsi(descriptor);
            if (psiElement == null) {
                return;
            }
            PsiElement annotation = psiElement;
            if (!this.isPluginEnabled(descriptor)) {
                SimpleDiagnostic simpleDiagnostic = BlockingBridgeErrors.BLOCKING_BRIDGE_PLUGIN_NOT_ENABLED.on(annotation);
                Intrinsics.checkNotNullExpressionValue((Object)simpleDiagnostic, (String)"BLOCKING_BRIDGE_PLUGIN_NOT_ENABLED.on(annotation)");
                AnalyzingKt.report(context, (Diagnostic)simpleDiagnostic);
                return;
            }
            if (((KtClass)declaration).isInterface()) {
                TargetPlatform targetPlatform = DescriptorUtilsKt.getModule((DeclarationDescriptor)descriptor).getPlatform();
                if (!(targetPlatform != null ? AnalyzingKt.isJvm8OrHigher(targetPlatform) : false)) {
                    SimpleDiagnostic simpleDiagnostic = BlockingBridgeErrors.INTERFACE_NOT_SUPPORTED.on(annotation);
                    Intrinsics.checkNotNullExpressionValue((Object)simpleDiagnostic, (String)"INTERFACE_NOT_SUPPORTED.on(annotation)");
                    AnalyzingKt.report(context, (Diagnostic)simpleDiagnostic);
                    return;
                }
            }
        } else if (ktDeclaration instanceof KtNamedFunction) {
            CheckResult checkResult = CheckResult.BREAK;
            if (checkResult == this.checkApplicability(declaration, descriptor, context) ? true : checkResult == this.checkJvmSynthetic(declaration, descriptor, context)) {
                return;
            }
            return;
        }
    }

    protected boolean isPluginEnabled(@NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return true;
    }

    private final CheckResult checkApplicability(KtDeclaration declaration, DeclarationDescriptor descriptor, DeclarationCheckerContext context) {
        PsiElement psiElement;
        IBridgeConfiguration $this$checkApplicability_u24lambda_u240 = (IBridgeConfiguration)this.ext.invoke((Object)declaration);
        boolean bl = false;
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
        switch (WhenMappings.$EnumSwitchMapping$0[UtilKt.hasJvmBlockingBridgeAnnotation(descriptor, bindingContext, $this$checkApplicability_u24lambda_u240.getEnableForModule()).ordinal()]) {
            case 1: {
                return CheckResult.CONTINUE;
            }
            case 2: 
            case 3: {
                return CheckResult.CONTINUE;
            }
            case 4: {
                psiElement = AnalyzingKt.jvmBlockingBridgeAnnotationPsi(descriptor);
                if (psiElement != null) break;
                psiElement = (PsiElement)declaration;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PsiElement inspectionTarget = psiElement;
        if (!this.isPluginEnabled(descriptor)) {
            SimpleDiagnostic simpleDiagnostic = BlockingBridgeErrors.BLOCKING_BRIDGE_PLUGIN_NOT_ENABLED.on(inspectionTarget);
            Intrinsics.checkNotNullExpressionValue((Object)simpleDiagnostic, (String)"BLOCKING_BRIDGE_PLUGIN_N\u2026BLED.on(inspectionTarget)");
            AnalyzingKt.report(context, (Diagnostic)simpleDiagnostic);
            return CheckResult.BREAK;
        }
        if (!(descriptor instanceof FunctionDescriptor)) {
            SimpleDiagnostic simpleDiagnostic = BlockingBridgeErrors.INAPPLICABLE_JVM_BLOCKING_BRIDGE.on(inspectionTarget);
            Intrinsics.checkNotNullExpressionValue((Object)simpleDiagnostic, (String)"INAPPLICABLE_JVM_BLOCKIN\u2026IDGE.on(inspectionTarget)");
            AnalyzingKt.report(context, (Diagnostic)simpleDiagnostic);
            return CheckResult.BREAK;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
        BindingContext bindingContext2 = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"context.trace.bindingContext");
        BlockingBridgeAnalyzeResult result = AnalyzeCapabilityForGeneratingBridgesKt.analyzeCapabilityForGeneratingBridges(functionDescriptor, bindingContext2, $this$checkApplicability_u24lambda_u240);
        Diagnostic diagnostic = result.createDiagnostic();
        if (diagnostic != null) {
            Diagnostic p0 = diagnostic;
            boolean bl2 = false;
            AnalyzingKt.report(context, p0);
        }
        if (result instanceof BlockingBridgeAnalyzeResult.BridgeAnnotationFromContainingDeclaration) {
            return CheckResult.BREAK;
        }
        return CheckResult.CONTINUE;
    }

    private final CheckResult checkJvmSynthetic(KtDeclaration declaration, DeclarationDescriptor descriptor, DeclarationCheckerContext context) {
        Object object;
        IBridgeConfiguration $this$checkJvmSynthetic_u24lambda_u241 = (IBridgeConfiguration)this.ext.invoke((Object)declaration);
        boolean bl = false;
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
        switch (WhenMappings.$EnumSwitchMapping$0[UtilKt.hasJvmBlockingBridgeAnnotation(descriptor, bindingContext, $this$checkJvmSynthetic_u24lambda_u241.getEnableForModule()).ordinal()]) {
            case 1: {
                return CheckResult.CONTINUE;
            }
            case 4: {
                object = AnalyzingKt.jvmBlockingBridgeAnnotationPsi(descriptor);
                if (object != null) break;
                AnnotationDescriptor annotationDescriptor = descriptor.getAnnotations().findAnnotation(JVM_SYNTHETIC);
                object = annotationDescriptor != null ? AnalyzingKt.findPsi(annotationDescriptor) : null;
                if (object != null) break;
                object = (PsiElement)declaration;
                break;
            }
            case 2: 
            case 3: {
                return CheckResult.CONTINUE;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PsiElement inspectionTarget = object;
        if (JvmAnnotationUtilKt.hasJvmSyntheticAnnotation((DeclarationDescriptor)descriptor)) {
            SimpleDiagnostic simpleDiagnostic = BlockingBridgeErrors.REDUNDANT_JVM_BLOCKING_BRIDGE_WITH_JVM_SYNTHETIC.on(inspectionTarget);
            Intrinsics.checkNotNullExpressionValue((Object)simpleDiagnostic, (String)"REDUNDANT_JVM_BLOCKING_B\u2026ETIC.on(inspectionTarget)");
            AnalyzingKt.report(context, (Diagnostic)simpleDiagnostic);
            return CheckResult.CONTINUE;
        }
        return CheckResult.CONTINUE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lme/him188/kotlin/jvm/blocking/bridge/compiler/diagnostic/BlockingBridgeDeclarationChecker$CheckResult;", "", "(Ljava/lang/String;I)V", "CONTINUE", "BREAK", "kotlin-jvm-blocking-bridge-compiler"})
    public static final class CheckResult
    extends Enum<CheckResult> {
        public static final /* enum */ CheckResult CONTINUE = new CheckResult();
        public static final /* enum */ CheckResult BREAK = new CheckResult();
        private static final /* synthetic */ CheckResult[] $VALUES;

        public static CheckResult[] values() {
            return (CheckResult[])$VALUES.clone();
        }

        public static CheckResult valueOf(String value) {
            return Enum.valueOf(CheckResult.class, value);
        }

        static {
            $VALUES = checkResultArray = new CheckResult[]{CheckResult.CONTINUE, CheckResult.BREAK};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HasJvmBlockingBridgeAnnotation.values().length];
            try {
                nArray[HasJvmBlockingBridgeAnnotation.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HasJvmBlockingBridgeAnnotation.FROM_CONTAINING_DECLARATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HasJvmBlockingBridgeAnnotation.ENABLE_FOR_MODULE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HasJvmBlockingBridgeAnnotation.FROM_FUNCTION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/him188/kotlin/jvm/blocking/bridge/compiler/diagnostic/BlockingBridgeDeclarationChecker$Companion;", "", "()V", "JVM_SYNTHETIC", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin-jvm-blocking-bridge-compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

