/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.database;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.hsgamer.hscore.database.Driver;
import org.jetbrains.annotations.Contract;

public class Setting {
    private final Driver driver;
    private final Map<String, Object> clientProperties;
    private final Map<String, Object> driverProperties;
    private String host;
    private String databaseName;
    private String port;
    private String username;
    private String password;

    private Setting(Driver driver) {
        this.driver = driver;
        this.clientProperties = new HashMap<String, Object>();
        this.driverProperties = new HashMap<String, Object>();
        this.host = "localhost";
        this.databaseName = "";
        this.port = "";
        this.username = "root";
        this.password = "";
        driver.applyDefaultSetting(this);
    }

    public static Setting create(Driver driver) {
        return new Setting(driver);
    }

    public static Setting deserialize(Driver driver, Map<String, Object> map) {
        Setting setting = new Setting(driver);
        setting.host = (String)map.get("host");
        setting.databaseName = (String)map.get("databaseName");
        setting.port = (String)map.get("port");
        setting.username = (String)map.get("username");
        setting.password = (String)map.get("password");
        setting.clientProperties.putAll((Map)map.get("clientProperties"));
        setting.driverProperties.putAll((Map)map.get("driverProperties"));
        return setting;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("host", this.host);
        map.put("databaseName", this.databaseName);
        map.put("port", this.port);
        map.put("username", this.username);
        map.put("password", this.password);
        map.put("clientProperties", this.clientProperties);
        map.put("driverProperties", this.driverProperties);
        return map;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public String getHost() {
        return this.host;
    }

    @Contract(value="_ -> this")
    public Setting setHost(String host) {
        this.host = host;
        return this;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Contract(value="_ -> this")
    public Setting setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String getPort() {
        return this.port;
    }

    @Contract(value="_ -> this")
    public Setting setPort(String port) {
        this.port = port;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    @Contract(value="_ -> this")
    public Setting setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    @Contract(value="_ -> this")
    public Setting setPassword(String password) {
        this.password = password;
        return this;
    }

    @Contract(value="_, _ -> this")
    public Setting setClientProperty(String property, Object value) {
        this.clientProperties.put(property, value);
        return this;
    }

    public Map<String, Object> getClientProperties() {
        return Collections.unmodifiableMap(this.clientProperties);
    }

    @Contract(value="_ -> this")
    public Setting setClientProperties(Map<String, Object> properties) {
        this.clientProperties.putAll(properties);
        return this;
    }

    public List<String> getClientPropertyStrings() {
        return Collections.unmodifiableList(this.clientProperties.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.toList()));
    }

    @Contract(value="_, _ -> this")
    public Setting setDriverProperty(String property, Object value) {
        this.driverProperties.put(property, value);
        return this;
    }

    public Map<String, Object> getDriverProperties() {
        return Collections.unmodifiableMap(this.driverProperties);
    }

    @Contract(value="_ -> this")
    public Setting setDriverProperties(Map<String, Object> properties) {
        this.driverProperties.putAll(properties);
        return this;
    }

    public List<String> getDriverPropertyStrings() {
        return Collections.unmodifiableList(this.driverProperties.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.toList()));
    }

    public String getNormalizedHost() {
        return this.host + (this.port.isEmpty() ? "" : ":" + this.port);
    }
}

