/*
 * Decompiled with CFR 0.152.
 */
package me.ibrt.loopback.query;

import me.ibrt.loopback.query.Serializer;

public final class Order {
    private final String propertyName;
    private final Direction direction;

    public Order(String propertyName, Direction direction) {
        this.propertyName = propertyName;
        this.direction = direction;
    }

    public static Order newAsc(String propertyName) {
        return new Order(propertyName, Direction.ASCENDING);
    }

    public static Order newDesc(String propertyName) {
        return new Order(propertyName, Direction.DESCENDING);
    }

    public String toString() {
        return Serializer.newSerializer().unquoted(this.propertyName).literal(Serializer.Literal.SPACE).unquoted(this.direction.toString()).toString();
    }

    public static enum Direction {
        ASCENDING("ASC"),
        DESCENDING("DESC");

        private final String string;

        private Direction(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

