/*
 * Decompiled with CFR 0.152.
 */
package me.ibrt.loopback.query;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.ibrt.loopback.query.Include;
import me.ibrt.loopback.query.Order;
import me.ibrt.loopback.query.Serializer;
import me.ibrt.loopback.query.Serializers;
import me.ibrt.loopback.query.Where;

public final class Query {
    private final List<String> fields = new ArrayList<String>();
    private final List<Order> orders = new ArrayList<Order>();
    private final Map<String, String> custom = new HashMap<String, String>();
    private Include include;
    private Integer limit;
    private Integer skip;
    private Where where;

    public Query addField(String field) {
        this.fields.add(field);
        return this;
    }

    public Query addFields(String ... fields) {
        for (String field : fields) {
            this.fields.add(field);
        }
        return this;
    }

    public Query addOrder(Order order) {
        this.orders.add(order);
        return this;
    }

    public Query addOrders(Order ... orders) {
        this.addOrders(orders);
        return this;
    }

    public Query addOrders(Iterable<Order> orders) {
        for (Order order : orders) {
            this.orders.add(order);
        }
        return this;
    }

    public Query setInclude(Include include) {
        this.include = include;
        return this;
    }

    public Query setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Query setSkip(Integer skip) {
        this.skip = skip;
        return this;
    }

    public Query setCustom(String key, String value) {
        this.custom.put(key, value);
        return this;
    }

    public Query setWhere(Where where) {
        this.where = where;
        return this;
    }

    public String toString() {
        return Serializer.newSerializer().literal(Serializer.Literal.OPEN_BRACE).literal(Serializer.Literal.SPACE).push().unquoted(Serializers.serializeWhere(this.where)).push().unquoted(Serializers.serializeFields(this.fields)).push().unquoted(Serializers.serializeOrders(this.orders)).push().unquoted(Serializers.serializeInclude(this.include)).push().unquoted(Serializers.serializeLimit(this.limit)).push().unquoted(Serializers.serializeSkip(this.skip)).push().unquoted(Serializers.serializeCustom(this.custom)).pop(7, Serializer.Literal.COMMA_SPACE).literal(Serializer.Literal.SPACE).literal(Serializer.Literal.CLOSE_BRACE).toString();
    }

    public String toURLEncodedString() {
        try {
            return URLEncoder.encode(this.toString(), "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Query newQuery() {
        return new Query();
    }
}

