/*
 * Decompiled with CFR 0.152.
 */
package me.ibrt.loopback.query;

import java.util.ArrayList;
import java.util.List;

public class Serializer {
    private final List<StringBuilder> stack = new ArrayList<StringBuilder>();

    public Serializer() {
        this.stack.add(new StringBuilder());
    }

    public Serializer literal(Literal literal) {
        this.top().append((Object)literal);
        return this;
    }

    public <T> Serializer quoted(T object) {
        this.top().append((Object)Literal.QUOTE).append(object.toString()).append((Object)Literal.QUOTE);
        return this;
    }

    public <T> Serializer unquoted(T object) {
        this.top().append(object.toString());
        return this;
    }

    public Serializer push() {
        this.stack.add(new StringBuilder());
        return this;
    }

    public Serializer pop(int count, Literal join) {
        while (count > 0) {
            String last = this.pop().toString();
            if (last.length() > 0) {
                if (count > 1 && this.top().toString().length() > 0) {
                    this.top().append((Object)join);
                }
                this.top().append(last);
            }
            --count;
        }
        return this;
    }

    public String toString() {
        if (this.stack.size() != 1) {
            throw new IllegalStateException("Stack must contain only one element in order to convert Serializer to string.");
        }
        return this.stack.get(0).toString();
    }

    private StringBuilder top() {
        this.ensureNotEmpty();
        return this.stack.get(this.stack.size() - 1);
    }

    private StringBuilder pop() {
        this.ensureNotEmpty();
        StringBuilder x = this.stack.remove(this.stack.size() - 1);
        return x;
    }

    private void ensureNotEmpty() {
        if (this.stack.size() == 0) {
            throw new IllegalStateException("Serializer stack is empty.");
        }
    }

    public static Serializer newSerializer() {
        return new Serializer();
    }

    public static enum Literal {
        OPEN_BRACE("{"),
        CLOSE_BRACE("}"),
        OPEN_SQUARE("["),
        CLOSE_SQUARE("]"),
        QUOTE("\""),
        SPACE(" "),
        COLUMN(":"),
        COMMA(","),
        COMMA_SPACE(", "),
        EMPTY(""),
        TRUE("true"),
        FALSE("false");

        private final String literal;

        private Literal(String literal) {
            this.literal = literal;
        }

        public String toString() {
            return this.literal;
        }
    }
}

