/*
 * Decompiled with CFR 0.152.
 */
package me.ibrt.loopback.query;

import java.util.List;
import java.util.Map;
import me.ibrt.loopback.query.Include;
import me.ibrt.loopback.query.Order;
import me.ibrt.loopback.query.Serializer;
import me.ibrt.loopback.query.Where;

public final class Serializers {
    private Serializers() {
    }

    public static String serializeFields(List<String> fields) {
        if (fields.size() == 0) {
            return "";
        }
        Serializer serializer = Serializer.newSerializer().quoted("fields").literal(Serializer.Literal.COLUMN).literal(Serializer.Literal.SPACE).literal(Serializer.Literal.OPEN_BRACE).literal(Serializer.Literal.SPACE);
        for (String field : fields) {
            serializer.push().quoted(field).literal(Serializer.Literal.COLUMN).literal(Serializer.Literal.SPACE).literal(Serializer.Literal.TRUE);
        }
        return serializer.pop(fields.size(), Serializer.Literal.COMMA_SPACE).literal(Serializer.Literal.SPACE).literal(Serializer.Literal.CLOSE_BRACE).toString();
    }

    public static String serializeOrders(List<Order> orders) {
        if (orders.size() == 0) {
            return "";
        }
        Serializer serializer = Serializer.newSerializer().quoted("order").literal(Serializer.Literal.COLUMN).literal(Serializer.Literal.SPACE);
        if (orders.size() == 1) {
            return serializer.quoted(orders.get(0)).toString();
        }
        serializer.literal(Serializer.Literal.OPEN_SQUARE).literal(Serializer.Literal.SPACE);
        for (Order order : orders) {
            serializer.push().quoted(order);
        }
        return serializer.pop(orders.size(), Serializer.Literal.COMMA_SPACE).literal(Serializer.Literal.SPACE).literal(Serializer.Literal.CLOSE_SQUARE).toString();
    }

    public static String serializeCustom(Map<String, String> custom) {
        if (custom.size() == 0) {
            return "";
        }
        Serializer serializer = Serializer.newSerializer();
        for (Map.Entry<String, String> entry : custom.entrySet()) {
            serializer.push().quoted(entry.getKey()).literal(Serializer.Literal.COLUMN).literal(Serializer.Literal.SPACE).unquoted(entry.getValue());
        }
        return serializer.pop(custom.size(), Serializer.Literal.COMMA_SPACE).toString();
    }

    public static String serializeLimit(Integer limit) {
        return Serializers.serializeKeyValue("limit", limit);
    }

    public static String serializeSkip(Integer skip) {
        return Serializers.serializeKeyValue("skip", skip);
    }

    public static String serializeInclude(Include include) {
        return Serializers.serializeKeyValue("include", include);
    }

    public static String serializeWhere(Where where) {
        return Serializers.serializeKeyValue("where", where);
    }

    public static String serializeKeyValue(String key, Object value) {
        if (value == null) {
            return "";
        }
        return Serializer.newSerializer().quoted(key).literal(Serializer.Literal.COLUMN).literal(Serializer.Literal.SPACE).unquoted(value).toString();
    }

    public static String serializeObject(Object object) {
        if (object instanceof String) {
            return (Object)((Object)Serializer.Literal.QUOTE) + object.toString() + (Object)((Object)Serializer.Literal.QUOTE);
        }
        return object.toString();
    }
}

