/*
 * Decompiled with CFR 0.152.
 */
package me.ibrt.loopback.query;

import me.ibrt.loopback.query.Serializer;
import me.ibrt.loopback.query.Serializers;

public class Where {
    private final Clause clause;

    public Where(Clause clause) {
        this.clause = clause;
    }

    public String toString() {
        return this.clause.toString();
    }

    public static Where newWhere(Clause clause) {
        return new Where(clause);
    }

    public static enum Operator {
        AND,
        OR,
        GT,
        GTE,
        LT,
        LTE,
        BETWEEN,
        INQ,
        NIN,
        NEAR,
        NEQ,
        LIKE,
        NLIKE,
        REGEXP;


        public String toString() {
            return this.name().toLowerCase();
        }

        public Operation p(Object ... parameters) {
            return Operation.newOperation(this, parameters);
        }
    }

    public static final class Operation {
        private final Operator operator;
        private final Object[] parameters;

        public Operation(Operator operator, Object ... parameters) {
            if (parameters.length == 0) {
                throw new IllegalArgumentException("Operation requires at least one parameter.");
            }
            this.operator = operator;
            this.parameters = parameters;
        }

        public String toString() {
            Serializer serializer = Serializer.newSerializer().literal(Serializer.Literal.OPEN_BRACE).literal(Serializer.Literal.SPACE).quoted(this.operator).literal(Serializer.Literal.COLUMN).literal(Serializer.Literal.SPACE);
            if (this.parameters.length == 1) {
                serializer.unquoted(Serializers.serializeObject(this.parameters[0]));
            }
            if (this.parameters.length > 1) {
                serializer.literal(Serializer.Literal.OPEN_SQUARE).literal(Serializer.Literal.SPACE);
                for (Object parameter : this.parameters) {
                    serializer.push().unquoted(Serializers.serializeObject(parameter));
                }
                serializer.pop(this.parameters.length, Serializer.Literal.COMMA_SPACE).literal(Serializer.Literal.SPACE).literal(Serializer.Literal.CLOSE_SQUARE);
            }
            return serializer.literal(Serializer.Literal.SPACE).literal(Serializer.Literal.CLOSE_BRACE).toString();
        }

        public static Operation newOperation(Operator operator, Object ... parameters) {
            return new Operation(operator, parameters);
        }
    }

    public static final class Clause {
        private final String propertyName;
        private final Object value;

        public Clause(String propertyName, Object value) {
            this.propertyName = propertyName;
            this.value = value;
        }

        public String toString() {
            return Serializer.newSerializer().literal(Serializer.Literal.OPEN_BRACE).literal(Serializer.Literal.SPACE).quoted(this.propertyName).literal(Serializer.Literal.COLUMN).literal(Serializer.Literal.SPACE).unquoted(Serializers.serializeObject(this.value)).literal(Serializer.Literal.SPACE).literal(Serializer.Literal.CLOSE_BRACE).toString();
        }

        public static Clause newClause(String propertyName, Object value) {
            return new Clause(propertyName, value);
        }

        public static Clause c(String propertyName, Object value) {
            return Clause.newClause(propertyName, value);
        }
    }
}

