/*
 Syntax is distributed under the Revised, or 3-clause BSD license
 ===============================================================================
 Copyright (c) 1985, 2012, 2016, Jaime Garza
 All rights reserved.
 
 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:
     * Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
     * Neither the name of the copyright holder nor the
       names of its contributors may be used to endorse or promote products
       derived from this software without specific prior written permission.
 
 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
 DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ===============================================================================
*/
package me.jaimegarza.syntax.code;

import java.util.ListResourceBundle;

/**
 * This class is used as a default catch it all
 * resource bundle for all languages.<p>
 * 
 * It also provides the "name" of the resource
 * during initialization of the environment by
 * pulling its canonical class name.
 * 
 * Please be advised that {1} is interpreted to be the
 * indentation string required.  Always.  This is a
 * contract.
 *
 * @author jaimegarza@gmail.com
 *
 */
public class Fragments extends ListResourceBundle{
  
  public static final String HELLO = "hello";
  public static final String STXSTACK = "stxstack";
  public static final String GETC = "getc";
  public static final String LEXICAL_VALUE = "lexicalValue";
  public static final String CURRENT_CHAR = "currentChar";
  public static final String RETURN_VALUE = "returnValue";
  public static final String LEXER_MODE = "lexerMode";
  public static final String TOKEN= "returnToken"; 
  public static final String RECOGNIZED= "recognized";
  public static final String LEXER_FUNCTION_NAME = "lexerFunctionName"; 
  public static final String RETURN = "return"; 

  @Override
  protected Object[][] getContents() {
    return contents;
  }

  private Object[] contents [] = {
      {HELLO,"Hola Mundo"}, // keep, for unit testing
      {STXSTACK, "StxStack[{0}]"}
  };

}
