/*
 Syntax is distributed under the Revised, or 3-clause BSD license
 ===============================================================================
 Copyright (c) 1985, 2012, 2016, Jaime Garza
 All rights reserved.
 
 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:
     * Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
     * Neither the name of the copyright holder nor the
       names of its contributors may be used to endorse or promote products
       derived from this software without specific prior written permission.
 
 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY
 DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ===============================================================================
*/
package me.jaimegarza.syntax.language;

/**
 * Languages generated by the compiler-compiler
 * 
 * TODO: P1-Add javascript
 * TODO: P3-Add scala
 * 
 * A language is composed by its extension, include file 
 * extension and a locale. Assigning a locale 
 * would allow us to use resource bundles.
 * 
 * @author jaimegarza@gmail.com
 */
public enum Language {
  C(C.class),
  java(Java.class), 
  pascal(Pascal.class),
  javascript(Javascript.class);

  Class<? extends LanguageSupport> clazz;
  LanguageSupport support = null;
  
  /**
   * Define one Language enum
   * @param fileExt is the file extension
   * @param incExt is the extension for the external include file
   * @param bundleCode is the code to be use for resource bundle
   */
  Language(Class<? extends LanguageSupport> clazz) {
    this.clazz = clazz;
  }

  public LanguageSupport support() {
    if (support == null) {
      try {
        support = clazz.newInstance();
      } catch (InstantiationException ignored) {
      } catch (IllegalAccessException ignored) {
      }
    }
    return support;
  }
}
