/*
 * Decompiled with CFR 0.152.
 */
package me.jaksa.hbase.lite;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import me.jaksa.hbase.lite.Converter;
import me.jaksa.hbase.lite.HColumn;
import me.jaksa.hbase.lite.JPAUtils;
import me.jaksa.hbase.lite.SerializableUtils;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;

class GenericConverter<T>
implements Converter<T> {
    private Class<T> clazz;
    private Field keyField;
    private Map<Field, HColumn> columns;

    public GenericConverter() {
    }

    public GenericConverter(Class<T> clazz) {
        this.setElementClass(clazz);
    }

    void setElementClass(Class<T> clazz) {
        this.clazz = clazz;
        this.keyField = JPAUtils.getKeyField(clazz);
        this.keyField.setAccessible(true);
        this.columns = JPAUtils.getColumns(clazz);
        for (Field f : this.columns.keySet()) {
            f.setAccessible(true);
        }
    }

    public Class<T> getElementClass() {
        return this.clazz;
    }

    @Override
    public T convert(Result result) {
        try {
            T t = this.clazz.newInstance();
            this.keyField.set(t, SerializableUtils.fromBytes(result.getRow(), this.keyField.getType()));
            for (Field f : this.columns.keySet()) {
                HColumn column = this.columns.get(f);
                byte[] byteValue = result.getValue(column.family, column.name);
                Object value = SerializableUtils.fromBytes(byteValue, f.getType());
                f.set(t, value);
            }
            return t;
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Put toPut(T t) {
        try {
            Object keyValue = this.keyField.get(t);
            Put put = new Put(SerializableUtils.toBytes(keyValue, this.keyField.getType()));
            for (Field f : this.columns.keySet()) {
                HColumn column = this.columns.get(f);
                Object value = f.get(t);
                byte[] bytesValue = SerializableUtils.toBytes(value, f.getType());
                put.addColumn(column.family, column.name, bytesValue);
            }
            return put;
        }
        catch (IOException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

