/*
 * Decompiled with CFR 0.152.
 */
package me.jaksa.hbase.lite;

import java.io.IOException;
import java.io.Serializable;
import me.jaksa.hbase.lite.Converter;
import me.jaksa.hbase.lite.SerializableUtils;
import me.jaksa.hbase.lite.TempStorage;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.Mapper;

class Grouper<T extends Serializable>
extends TableMapper<BytesWritable, BytesWritable> {
    private final BytesWritable ONE_KEY = new BytesWritable(new byte[]{42});
    private Converter<T> converter;

    Grouper() {
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.converter = TempStorage.getInstance().retrieveConverter(context);
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        Serializable t = (Serializable)this.converter.convert(value);
        context.write((Object)this.ONE_KEY, (Object)new BytesWritable(SerializableUtils.toBytes(t)));
    }
}

