/*
 * Decompiled with CFR 0.152.
 */
package me.jaksa.hbase.lite;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import me.jaksa.hbase.lite.HColumn;

public class JPAUtils {
    public static String getTableName(Class clazz) {
        String name;
        Table entity = clazz.getAnnotation(Table.class);
        if (entity != null && (name = entity.name()) != null && !name.isEmpty()) {
            return name;
        }
        String simpleName = clazz.getSimpleName();
        return simpleName.endsWith("s") ? simpleName + "es" : simpleName + "s";
    }

    public static Map<Field, HColumn> getColumns(Class clazz) {
        HashMap<Field, HColumn> fields = new HashMap<Field, HColumn>();
        for (Field f : clazz.getDeclaredFields()) {
            if (JPAUtils.isIdentifier(f)) continue;
            fields.put(f, new HColumn(JPAUtils.getColumnFamily(f), JPAUtils.getColumnName(f)));
        }
        return fields;
    }

    public static <T> Field getKeyField(Class<T> clazz) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!JPAUtils.isIdentifier(f)) continue;
            return f;
        }
        throw new RuntimeException("Class " + clazz.getName() + " doesn't have a primary key. " + "Please annotate a field with javax.persistence.Id.");
    }

    private static boolean isIdentifier(Field f) {
        return f.getAnnotation(Id.class) != null;
    }

    private static String getColumnName(Field f) {
        String name;
        Column column = f.getAnnotation(Column.class);
        if (column != null && !(name = column.name()).isEmpty()) {
            String[] parts = name.split(":");
            if (parts.length == 2) {
                return parts[1];
            }
            return parts[0];
        }
        return f.getName();
    }

    private static String getColumnFamily(Field f) {
        String[] parts;
        String name;
        Column column = f.getAnnotation(Column.class);
        if (column != null && !(name = column.name()).isEmpty() && (parts = name.split(":")).length == 2) {
            return parts[0];
        }
        return "cf";
    }
}

