/*
 * Decompiled with CFR 0.152.
 */
package me.jaksa.hbase.lite;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.jaksa.hbase.lite.Converter;
import me.jaksa.hbase.lite.GenericConverter;
import me.jaksa.hbase.lite.Grouper;
import me.jaksa.hbase.lite.MapperAdaptor;
import me.jaksa.hbase.lite.PartitionFunction;
import me.jaksa.hbase.lite.PartitionedReducerAdaptor;
import me.jaksa.hbase.lite.ReducerAdaptor;
import me.jaksa.hbase.lite.SerializableFunction;
import me.jaksa.hbase.lite.TempStorage;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.Job;

class JobBuilder {
    private final HTable sourceTable;
    private final TempStorage tempStorage;
    private final Configuration configuration;
    private final Converter converter;
    private final Scan scan;
    private Job job;
    private List<SerializableFunction> mappers;
    private Function reducer;

    public JobBuilder(HTable sourceTable, TempStorage tempStorage, Configuration configuration, Converter converter, Scan scan) {
        this.sourceTable = sourceTable;
        this.tempStorage = tempStorage;
        this.configuration = configuration;
        this.converter = converter;
        this.scan = scan;
    }

    public void addMapper(SerializableFunction mapper) {
        if (this.mappers == null) {
            this.mappers = new ArrayList<SerializableFunction>();
        }
        this.mappers.add(mapper);
    }

    public void addPartitioner(PartitionFunction partitioner) {
        if (this.mappers == null) {
            this.mappers = new ArrayList<SerializableFunction>();
        }
        this.mappers.add(partitioner);
    }

    public void setReducer(Function reducer) {
        this.reducer = reducer;
    }

    public Job createJob() throws IOException {
        this.job = Job.getInstance((Configuration)this.configuration);
        this.job.setJarByClass(this.getClassForJar());
        TableMapReduceUtil.addDependencyJars((Job)this.job);
        this.tempStorage.storeConverter(this.job, this.converter);
        if (this.converter instanceof GenericConverter) {
            this.tempStorage.storeElementClass(this.job, (GenericConverter)this.converter);
        }
        this.tempStorage.storeReducerFunction(this.job, (Serializable)((Object)this.reducer));
        if (this.mappers == null) {
            TableMapReduceUtil.initTableMapperJob((byte[])this.sourceTable.getName().getName(), (Scan)this.scan, Grouper.class, BytesWritable.class, BytesWritable.class, (Job)this.job);
        } else {
            this.tempStorage.storeMapperFunctions(this.job, this.mappers);
            TableMapReduceUtil.initTableMapperJob((byte[])this.sourceTable.getName().getName(), (Scan)this.scan, MapperAdaptor.class, BytesWritable.class, BytesWritable.class, (Job)this.job);
        }
        if (!this.hasPartitioners()) {
            TableMapReduceUtil.initTableReducerJob((String)"_hbase-lite-temp", ReducerAdaptor.class, (Job)this.job);
            this.job.setNumReduceTasks(1);
        } else {
            TableMapReduceUtil.initTableReducerJob((String)"_hbase-lite-temp", PartitionedReducerAdaptor.class, (Job)this.job);
        }
        return this.job;
    }

    private boolean hasPartitioners() {
        if (this.mappers == null) {
            return false;
        }
        for (SerializableFunction mapper : this.mappers) {
            if (!(mapper instanceof PartitionFunction)) continue;
            return true;
        }
        return false;
    }

    public <R> R reduceToSingleValue() throws IOException {
        try {
            boolean success;
            if (this.job == null) {
                this.job = this.createJob();
            }
            if (!(success = this.job.waitForCompletion(true))) {
                throw new IOException("Failed processing " + this.job.getStatus().getFailureInfo());
            }
            Object result = this.tempStorage.retrieveResult(this.job);
            return result != null ? result : this.reducer.apply(Collections.emptyList());
        }
        catch (ClassNotFoundException | InterruptedException e) {
            throw new IOException(e);
        }
    }

    public <K, R extends Serializable> Map<K, R> reduceToMultipleValues() throws IOException {
        try {
            boolean success;
            if (this.job == null) {
                this.job = this.createJob();
            }
            if (!(success = this.job.waitForCompletion(true))) {
                throw new IOException("Failed processing " + this.job.getStatus().getFailureInfo());
            }
            Map result = this.tempStorage.retrieveResults(this.job);
            return result != null ? result : Collections.emptyMap();
        }
        catch (ClassNotFoundException | InterruptedException e) {
            throw new IOException(e);
        }
    }

    private Class<?> getClassForJar() {
        if (this.mappers != null) {
            return this.mappers.get(0).getClass();
        }
        if (this.reducer != null) {
            return this.reducer.getClass();
        }
        return JobBuilder.class;
    }
}

