/*
 * Decompiled with CFR 0.152.
 */
package me.jaksa.hbase.lite;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import me.jaksa.hbase.lite.Converter;
import me.jaksa.hbase.lite.PartitionFunction;
import me.jaksa.hbase.lite.SerializableFunction;
import me.jaksa.hbase.lite.SerializableUtils;
import me.jaksa.hbase.lite.TempStorage;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.Mapper;

class MapperAdaptor<T, I extends Serializable>
extends TableMapper<BytesWritable, BytesWritable> {
    private Converter<T> converter;
    private List<SerializableFunction> mappers;

    MapperAdaptor() {
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        TempStorage tempStorage = TempStorage.getInstance();
        this.converter = tempStorage.retrieveConverter(context);
        this.mappers = tempStorage.loadMapperFunctions(context);
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        Object t = this.converter.convert(value);
        ArrayList outKey = new ArrayList();
        for (SerializableFunction mapper : this.mappers) {
            if (mapper instanceof PartitionFunction) {
                outKey.add(mapper.apply(t));
                continue;
            }
            t = mapper.apply(t);
        }
        byte[] outkeyBytes = outKey.size() == 1 ? SerializableUtils.toBytes((Serializable)outKey.get(0)) : SerializableUtils.toBytes(outKey);
        context.write((Object)new BytesWritable(outkeyBytes), (Object)new BytesWritable(SerializableUtils.toBytes((Serializable)t)));
    }
}

