/*
 * Decompiled with CFR 0.152.
 */
package me.jaksa.hbase.lite;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import me.jaksa.hbase.lite.JobBuilder;
import me.jaksa.hbase.lite.PartitionFunction;
import me.jaksa.hbase.lite.Partitioned;
import me.jaksa.hbase.lite.SerializableFunction;

class PartitionedImpl<K, T>
implements Partitioned<K, T> {
    private final JobBuilder jobBuilder;

    public PartitionedImpl(JobBuilder jobBuilder) {
        this.jobBuilder = jobBuilder;
    }

    @Override
    public <P> Partitioned<List, T> partitionBy(PartitionFunction<T, P> f) {
        this.jobBuilder.addPartitioner(f);
        return new PartitionedImpl<K, T>(this.jobBuilder);
    }

    @Override
    public <I> Partitioned<K, I> map(SerializableFunction<T, I> f) {
        this.jobBuilder.addMapper(f);
        return new PartitionedImpl<K, T>(this.jobBuilder);
    }

    @Override
    public <R extends Serializable> Map<K, R> reduce(SerializableFunction<Iterable<T>, R> f) throws IOException {
        this.jobBuilder.setReducer(f);
        return this.jobBuilder.reduceToMultipleValues();
    }
}

