/*
 * Decompiled with CFR 0.152.
 */
package me.jaksa.hbase.lite;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Serializable;
import me.jaksa.hbase.lite.SerializableFunction;
import me.jaksa.hbase.lite.SerializableUtils;
import me.jaksa.hbase.lite.TempStorage;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

class ReducerAdaptor<I, R extends Serializable>
extends TableReducer<BytesWritable, BytesWritable, Text> {
    private SerializableFunction<Iterable<I>, R> reducerFunction;

    ReducerAdaptor() {
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.reducerFunction = (SerializableFunction)TempStorage.getInstance().loadReducerFunction(context);
    }

    protected void reduce(BytesWritable key, Iterable<BytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Iterable domainObjects = Iterables.transform(values, result -> {
            try {
                return SerializableUtils.fromBytes(result.getBytes());
            }
            catch (Exception e) {
                return null;
            }
        });
        Serializable result2 = (Serializable)this.reducerFunction.apply(domainObjects);
        TempStorage.getInstance().storeResult(context, result2);
    }
}

