/*
 * Decompiled with CFR 0.152.
 */
package me.jaksa.hbase.lite;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.hadoop.hbase.util.Bytes;

class SerializableUtils {
    SerializableUtils() {
    }

    public static byte[] toBytes(Serializable o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(o);
        return baos.toByteArray();
    }

    public static Object fromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        return in.readObject();
    }

    public static Object fromBytes(byte[] byteValue, Class<?> type) throws IOException, ClassNotFoundException {
        if (type.equals(Integer.class)) {
            return Bytes.toInt((byte[])byteValue);
        }
        if (type.equals(String.class)) {
            return Bytes.toString((byte[])byteValue);
        }
        if (type.equals(Long.class)) {
            return Bytes.toLong((byte[])byteValue);
        }
        if (type.equals(Boolean.class)) {
            return Bytes.toBoolean((byte[])byteValue);
        }
        if (type.equals(Double.class)) {
            return Bytes.toDouble((byte[])byteValue);
        }
        if (type.equals(BigDecimal.class)) {
            return Bytes.toBigDecimal((byte[])byteValue);
        }
        if (type.equals(Float.class)) {
            return Float.valueOf(Bytes.toFloat((byte[])byteValue));
        }
        if (type.equals(Short.class)) {
            return Bytes.toShort((byte[])byteValue);
        }
        return SerializableUtils.fromBytes(byteValue);
    }

    public static byte[] toBytes(Object byteValue, Class<?> type) throws IOException {
        if (type.equals(Integer.class)) {
            return Bytes.toBytes((int)((Integer)byteValue));
        }
        if (type.equals(String.class)) {
            return Bytes.toBytes((String)((String)byteValue));
        }
        if (type.equals(Long.class)) {
            return Bytes.toBytes((long)((Long)byteValue));
        }
        if (type.equals(Boolean.class)) {
            return Bytes.toBytes((boolean)((Boolean)byteValue));
        }
        if (type.equals(Double.class)) {
            return Bytes.toBytes((double)((Double)byteValue));
        }
        if (type.equals(BigDecimal.class)) {
            return Bytes.toBytes((BigDecimal)((BigDecimal)byteValue));
        }
        if (type.equals(Float.class)) {
            return Bytes.toBytes((float)((Float)byteValue).floatValue());
        }
        if (type.equals(Short.class)) {
            return Bytes.toBytes((short)((Short)byteValue));
        }
        if (Serializable.class.isAssignableFrom(type)) {
            return SerializableUtils.toBytes((Serializable)byteValue);
        }
        throw new IllegalArgumentException("Could not deserialize type " + type.getName());
    }
}

