/*
 * Decompiled with CFR 0.152.
 */
package me.jaksa.hbase.lite;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.jaksa.hbase.lite.Converter;
import me.jaksa.hbase.lite.GenericConverter;
import me.jaksa.hbase.lite.HBaseLite;
import me.jaksa.hbase.lite.HColumn;
import me.jaksa.hbase.lite.JPAUtils;
import me.jaksa.hbase.lite.JobBuilder;
import me.jaksa.hbase.lite.Mapped;
import me.jaksa.hbase.lite.MappedImpl;
import me.jaksa.hbase.lite.PartitionFunction;
import me.jaksa.hbase.lite.Partitioned;
import me.jaksa.hbase.lite.PartitionedImpl;
import me.jaksa.hbase.lite.SerializableFunction;
import me.jaksa.hbase.lite.TempStorage;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

public class Table<T> {
    private final String name;
    private final Collection<HColumn> columns;
    private final Converter<T> converter;
    private HTable hTable;

    public Table(Class<T> clazz) {
        this(JPAUtils.getTableName(clazz), JPAUtils.getColumns(clazz).values(), new GenericConverter<T>(clazz));
    }

    public Table(String name, String columns, Converter<T> converter) {
        this(name, Table.extractColumns(columns), converter);
    }

    public Table(HTable hTable, String columns, Converter<T> converter) {
        this(hTable.getName().getNameAsString(), columns, converter);
        this.hTable = hTable;
    }

    Table(String name, Collection<HColumn> columns, Converter<T> converter) {
        this.name = name;
        this.columns = columns;
        this.converter = converter;
    }

    public T get(Object key) throws IOException {
        Get get = new Get(Table.toBytes(key));
        for (HColumn column : this.columns) {
            get.addColumn(column.family, column.name);
        }
        Result result = this.getHTable().get(get);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return this.converter.convert(result);
    }

    public void put(T t) throws IOException {
        HTable hTable = this.getHTable();
        hTable.put(this.converter.toPut(t));
        hTable.flushCommits();
    }

    public void delete(Object key) throws IOException {
        Delete delete = new Delete(Table.toBytes(key));
        HTable hTable = this.getHTable();
        hTable.delete(delete);
        hTable.flushCommits();
    }

    public <P> Partitioned<P, T> partitionBy(PartitionFunction<T, P> f) throws IOException {
        JobBuilder jobBuilder = this.createJobBuilder();
        jobBuilder.addPartitioner(f);
        return new PartitionedImpl(jobBuilder);
    }

    public <I> Mapped<I> map(SerializableFunction<T, I> f) throws IOException {
        JobBuilder jobBuilder = this.createJobBuilder();
        jobBuilder.addMapper(f);
        return new MappedImpl(jobBuilder);
    }

    public <R extends Serializable> R reduce(SerializableFunction<Iterable<T>, R> f) throws IOException {
        JobBuilder jobBuilder = this.createJobBuilder();
        jobBuilder.setReducer(f);
        return (R)((Serializable)jobBuilder.reduceToSingleValue());
    }

    private JobBuilder createJobBuilder() throws IOException {
        TempStorage tempStorage = TempStorage.getInstance();
        return new JobBuilder(this.hTable, tempStorage, HBaseLite.getConfiguration(), this.converter, this.scan());
    }

    private Scan scan() {
        Scan scan = new Scan();
        for (HColumn column : this.columns) {
            scan.addColumn(column.family, column.name);
        }
        return scan;
    }

    private HTable getHTable() throws IOException {
        if (this.hTable == null) {
            this.hTable = new HTable(HBaseLite.getConfiguration(), this.name);
        }
        return this.hTable;
    }

    static List<HColumn> extractColumns(String columns) {
        ArrayList<HColumn> columnsList = new ArrayList<HColumn>();
        if (columns == null || columns.isEmpty()) {
            throw new IllegalArgumentException("you must specify some columns");
        }
        for (String columnString : columns.split("\\s*,\\s*")) {
            String[] columnNameParts = columnString.split("\\s*:\\s*");
            if (columnNameParts.length != 2) {
                throw new IllegalArgumentException("no valid family name in " + columnString);
            }
            String family = columnNameParts[0];
            String columnName = columnNameParts[1];
            columnsList.add(new HColumn(family, columnName));
        }
        return columnsList;
    }

    static byte[] toBytes(Object key) {
        if (key instanceof String) {
            return Bytes.toBytes((String)((String)key));
        }
        if (key instanceof Integer) {
            return Bytes.toBytes((int)((Integer)key));
        }
        if (key instanceof Long) {
            return Bytes.toBytes((long)((Long)key));
        }
        if (key instanceof BigDecimal) {
            return Bytes.toBytes((BigDecimal)((BigDecimal)key));
        }
        if (key instanceof ByteBuffer) {
            return Bytes.toBytes((ByteBuffer)((ByteBuffer)key));
        }
        if (key instanceof Double) {
            return Bytes.toBytes((double)((Double)key));
        }
        if (key instanceof Float) {
            return Bytes.toBytes((float)((Float)key).floatValue());
        }
        if (key instanceof Short) {
            return Bytes.toBytes((short)((Short)key));
        }
        if (key instanceof Boolean) {
            return Bytes.toBytes((boolean)((Boolean)key));
        }
        throw new IllegalArgumentException("HBase doesn't support keys of type " + key.getClass().getName());
    }

    public void deleteAll() throws IOException {
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        ResultScanner scanner = this.getHTable().getScanner(this.scan());
        for (Result result : scanner) {
            Delete delete = new Delete(result.getRow());
            deletes.add(delete);
        }
        scanner.close();
        this.hTable.delete(deletes);
    }
}

