/*
 * Decompiled with CFR 0.152.
 */
package me.jaksa;

import java.util.function.Consumer;
import java.util.function.Function;
import me.jaksa.FunctionWithException;
import me.jaksa.Pair;
import me.jaksa.SupplierWithException;

public class FunctionalTransaction<T> {
    private SupplierWithException<T> function;
    private Consumer<T> rollback;
    private Runnable rollbackRunnable;
    private Consumer<T> commit;
    private Function<T, Boolean> verification;
    private int retries = 3;
    private T lastResult;
    private FunctionWithException<?, T> functionWithArgument;
    FunctionalTransaction<?> previous;
    Object resultOfPrevious;

    public FunctionalTransaction(SupplierWithException<T> function) {
        this.function = function;
        this.rollback = result -> {};
        this.rollbackRunnable = () -> {};
        this.commit = result -> {};
        this.verification = result -> true;
    }

    public <I> FunctionalTransaction(FunctionWithException<I, T> function, FunctionalTransaction<I> previous) {
        this.functionWithArgument = function;
        this.previous = previous;
        this.rollback = result -> {};
        this.rollbackRunnable = () -> {};
        this.commit = result -> {};
        this.verification = result -> true;
    }

    public FunctionalTransaction<T> withReset(Consumer<T> rollback) {
        return this.withRollback(rollback);
    }

    public FunctionalTransaction<T> withRollback(Consumer<T> rollback) {
        this.rollback = rollback;
        return this;
    }

    public FunctionalTransaction<T> withRollback(Runnable rollback) {
        this.rollbackRunnable = rollback;
        return this;
    }

    public FunctionalTransaction<T> withCommit(Consumer<T> commit) {
        this.commit = commit;
        return this;
    }

    public FunctionalTransaction<T> withVerification(Function<T, Boolean> verification) {
        this.verification = verification;
        return this;
    }

    public FunctionalTransaction<T> retry(int times) {
        this.retries = times;
        return this;
    }

    public <R> FunctionalTransaction<R> then(FunctionWithException<T, R> function) {
        return new FunctionalTransaction<R>(function, this);
    }

    public <R> FunctionalTransaction<Pair<T, R>> and(FunctionWithException<T, R> f) {
        return this.then(t -> new Pair(t, f.apply(t)));
    }

    int getRetries() {
        return this.retries;
    }

    void performRollback() {
        this.rollback.accept(this.lastResult);
        this.rollbackRunnable.run();
    }

    void performCommit() {
        this.commit.accept(this.lastResult);
    }

    T evaluate() throws Exception {
        this.lastResult = null;
        T t = this.lastResult = this.previous == null ? this.function.get() : this.functionWithArgument.apply(this.getResultOfPrevious());
        if (!this.verification.apply(this.lastResult).booleanValue()) {
            throw new RuntimeException("Verification failed.");
        }
        return this.lastResult;
    }

    <T> T getResultOfPrevious() {
        return (T)this.resultOfPrevious;
    }
}

