/*
 * Decompiled with CFR 0.152.
 */
package me.jaksa;

import java.util.ArrayList;
import java.util.List;
import me.jaksa.FunctionalTransaction;
import me.jaksa.Transactions;

class LongTransaction
implements AutoCloseable {
    private final List<FunctionalTransaction> steps = new ArrayList<FunctionalTransaction>();

    LongTransaction() {
    }

    public <T> T transactionally(FunctionalTransaction<T> operation) {
        this.steps.add(operation);
        return Transactions.prepareAll(operation);
    }

    public void commit() {
        for (FunctionalTransaction step : this.steps) {
            Transactions.commitAll(step);
        }
        this.steps.clear();
    }

    public void rollback() {
        for (FunctionalTransaction step : this.steps) {
            Transactions.rollbackAll(step);
        }
        this.steps.clear();
    }

    @Override
    public void close() throws Exception {
        this.commit();
    }
}

