/*
 * Decompiled with CFR 0.152.
 */
package me.jaksa;

import me.jaksa.FunctionalTransaction;
import me.jaksa.LongTransaction;
import me.jaksa.RunnableWithException;

public class LongTransactions {
    private static ThreadLocal<LongTransaction> longTransactions = new ThreadLocal();

    public static void longTransaction(RunnableWithException r) {
        try {
            LongTransaction tx = LongTransactions.beginTx();
            r.run();
            LongTransactions.commitTx();
        }
        catch (Exception e) {
            LongTransactions.rollbackTx();
        }
    }

    public static LongTransaction beginTx() {
        LongTransaction tx = new LongTransaction();
        longTransactions.set(tx);
        return tx;
    }

    public static void commitTx() {
        LongTransactions.getLongTransaction().commit();
        longTransactions.set(null);
    }

    public static void rollbackTx() {
        LongTransactions.getLongTransaction().rollback();
        longTransactions.set(null);
    }

    public static <T> T transactionally(FunctionalTransaction<T> operation) {
        LongTransaction tx = LongTransactions.getLongTransaction();
        return tx.transactionally(operation);
    }

    private static LongTransaction getLongTransaction() {
        LongTransaction tx = longTransactions.get();
        if (tx == null) {
            throw new IllegalStateException("You need to perform this within a transaction. Use longTransaction() or beginTx()");
        }
        return tx;
    }
}

