/*
 * Decompiled with CFR 0.152.
 */
package me.jaksa;

import me.jaksa.FunctionalTransaction;
import me.jaksa.RunnableWithException;
import me.jaksa.SupplierWithException;
import me.jaksa.Unreliable;
import me.jaksa.VoidTransaction;

public class Transactions {
    public static VoidTransaction perform(RunnableWithException r) {
        return new VoidTransaction(r);
    }

    public static void atomically(VoidTransaction ... voidTransactions) {
        int operationsToRollback = 0;
        try {
            for (VoidTransaction voidTransaction : voidTransactions) {
                Unreliable.tenaciously(() -> {
                    try {
                        voidTransaction.run();
                    }
                    catch (Exception e) {
                        voidTransaction.performRollback();
                        throw e;
                    }
                }, voidTransaction.getRetries());
                ++operationsToRollback;
            }
        }
        catch (Exception e) {
            for (int i = 0; i < operationsToRollback; ++i) {
                voidTransactions[i].performRollback();
            }
            throw new RuntimeException(e);
        }
        for (VoidTransaction voidTransaction : voidTransactions) {
            voidTransaction.performCommit();
        }
    }

    public static <T> FunctionalTransaction<T> evaluate(SupplierWithException<T> function) {
        return new FunctionalTransaction<T>(function);
    }

    public static <T> T atomically(FunctionalTransaction<T> transaction) {
        T result = Transactions.prepareAll(transaction);
        Transactions.commitAll(transaction);
        return result;
    }

    static <R, T> T prepareAll(FunctionalTransaction<T> f) {
        if (f.previous == null) {
            return Transactions.prepare(f);
        }
        f.resultOfPrevious = Transactions.prepareAll(f.previous);
        try {
            return Transactions.prepare(f);
        }
        catch (Exception e) {
            Transactions.rollbackAll(f.previous);
            throw e;
        }
    }

    private static <T> T prepare(FunctionalTransaction<T> transaction) {
        return (T)Unreliable.tenaciously(() -> {
            try {
                return transaction.evaluate();
            }
            catch (Exception e) {
                transaction.performRollback();
                throw e;
            }
        }, transaction.getRetries());
    }

    static <R> void rollbackAll(FunctionalTransaction<R> f) {
        if (f.previous != null) {
            Transactions.rollbackAll(f.previous);
        }
        f.performRollback();
    }

    static <T> void commitAll(FunctionalTransaction<T> f) {
        if (f.previous != null) {
            Transactions.commitAll(f.previous);
        }
        f.performCommit();
    }
}

