/*
 * Decompiled with CFR 0.152.
 */
package me.jaksa;

import java.util.Collection;
import java.util.Collections;
import me.jaksa.RunnableWithException;
import me.jaksa.SupplierWithException;

public class Unreliable {
    public static final int DEFAILT_RETRIES = 3;

    public static void keepTrying(RunnableWithException r) {
        Unreliable.keepTrying(Unreliable.toSupplier(r));
    }

    public static <T> T keepTrying(SupplierWithException<T> s) {
        boolean success = true;
        while (true) {
            try {
                return s.get();
            }
            catch (Exception e) {
                if (!(success = false)) continue;
                throw new IllegalStateException();
            }
            break;
        }
    }

    public static void tenaciously(RunnableWithException r) {
        Unreliable.tenaciously(r, 3);
    }

    public static void tenaciously(RunnableWithException r, int times) {
        Unreliable.tenaciously(Unreliable.toSupplier(r), times);
    }

    public static <T> T tenaciously(SupplierWithException<T> s) {
        return Unreliable.tenaciously(s, 3);
    }

    public static <T> T tenaciously(SupplierWithException<T> s, int times) {
        return Unreliable.retryOn(Exception.class, s, times);
    }

    public static void retryOn(Class exceptionClass, RunnableWithException r) {
        Unreliable.retryOn(exceptionClass, Unreliable.toSupplier(r));
    }

    public static <T> T retryOn(Class exceptionClass, SupplierWithException<T> s) {
        return Unreliable.retryOn(exceptionClass, s, 3);
    }

    public static void retryOn(Class exceptionClass, RunnableWithException r, int times) {
        Unreliable.retryOn(exceptionClass, Unreliable.toSupplier(r), times);
    }

    public static <T> T retryOn(Class exceptionClass, SupplierWithException<T> s, int times) {
        return Unreliable.retryOn(Collections.singletonList(exceptionClass), s, times);
    }

    public static void retryOn(Collection<Class> exceptionClasses, RunnableWithException r) {
        Unreliable.retryOn(exceptionClasses, Unreliable.toSupplier(r), 3);
    }

    public static void retryOn(Collection<Class> exceptionClasses, RunnableWithException r, int times) {
        Unreliable.retryOn(exceptionClasses, Unreliable.toSupplier(r), times);
    }

    public static <T> T retryOn(Collection<Class> exceptionClasses, SupplierWithException<T> s) {
        return Unreliable.retryOn(exceptionClasses, s, 3);
    }

    public static <T> T retryOn(Collection<Class> exceptionClasses, SupplierWithException<T> s, int times) {
        boolean success = true;
        int tries = 0;
        Exception lastException = null;
        while (true) {
            try {
                ++tries;
                return s.get();
            }
            catch (Exception e) {
                if (exceptionClasses.stream().noneMatch(ex -> ex.isAssignableFrom(e.getClass()))) {
                    Unreliable.throwOrWrap(e);
                }
                success = false;
                lastException = e;
                if (!success && tries < times) continue;
                throw new RuntimeException("Tried " + tries + " times, but failed: " + lastException.getMessage(), lastException);
            }
            break;
        }
    }

    private static void throwOrWrap(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e.getMessage(), e);
    }

    private static SupplierWithException<Boolean> toSupplier(RunnableWithException s) {
        return () -> {
            s.run();
            return true;
        };
    }
}

