/*
 * Decompiled with CFR 0.152.
 */
package me.jaksa;

import java.util.function.Supplier;
import me.jaksa.RunnableWithException;

public class VoidTransaction {
    private RunnableWithException operation;
    private Runnable rollback;
    private Runnable commit;
    private Supplier<Boolean> verification;
    private int retries = 3;

    public VoidTransaction(RunnableWithException operation) {
        this.operation = operation;
        this.rollback = () -> {};
        this.commit = () -> {};
        this.verification = () -> true;
    }

    public VoidTransaction withReset(Runnable rollback) {
        return this.withRollback(rollback);
    }

    public VoidTransaction withRollback(Runnable rollback) {
        this.rollback = rollback;
        return this;
    }

    public VoidTransaction withCommit(Runnable commit) {
        this.commit = commit;
        return this;
    }

    public VoidTransaction withVerification(Supplier<Boolean> verification) {
        this.verification = verification;
        return this;
    }

    public VoidTransaction retry(int times) {
        this.retries = times;
        return this;
    }

    int getRetries() {
        return this.retries;
    }

    void performRollback() {
        this.rollback.run();
    }

    void performCommit() {
        this.commit.run();
    }

    void run() throws Exception {
        this.operation.run();
        if (!this.verification.get().booleanValue()) {
            throw new RuntimeException("Verification failed.");
        }
    }
}

