/*
 * Decompiled with CFR 0.152.
 */
package me.javaroad.web.exception;

import me.javaroad.common.exception.DataNotFoundException;
import me.javaroad.web.exception.ErrorCode;
import me.javaroad.web.exception.ErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@ControllerAdvice
public class DefaultExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultExceptionHandler.class);

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class, MethodArgumentNotValidException.class})
    @ResponseBody
    public ErrorResponse validationError(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return new ErrorResponse(ErrorCode.BAD_REQUEST.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={DataNotFoundException.class})
    @ResponseBody
    public ErrorResponse notFound(DataNotFoundException e) {
        log.info(e.getMessage(), (Throwable)e);
        return new ErrorResponse(ErrorCode.NOT_FOUND.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ErrorResponse notSupported(HttpRequestMethodNotSupportedException e) {
        return new ErrorResponse(ErrorCode.METHOD_NOT_ALLOWED.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ErrorResponse serverError(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return new ErrorResponse(ErrorCode.SERVER_ERROR.getCode(), e.getMessage());
    }
}

