/*
 * Decompiled with CFR 0.152.
 */
package me.kpavlov.aimocks.gemini;

import io.kotest.matchers.Matcher;
import io.ktor.serialization.Configuration;
import io.ktor.serialization.kotlinx.json.JsonSupportKt;
import io.ktor.server.plugins.contentnegotiation.ContentNegotiationConfig;
import java.util.Collection;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import me.kpavlov.aimocks.core.AbstractMockLlm;
import me.kpavlov.aimocks.gemini.GenerateContentRequest;
import me.kpavlov.aimocks.gemini.GenerationConfig;
import me.kpavlov.aimocks.gemini.content.GeminiContentBuildingStep;
import me.kpavlov.aimocks.gemini.content.GeminiContentRequestSpecification;
import me.kpavlov.aimocks.gemini.content.GeminiStreamingContentBuildingStep;
import me.kpavlov.mokksy.BuildingStep;
import me.kpavlov.mokksy.MokksyServer;
import me.kpavlov.mokksy.ServerConfiguration;
import me.kpavlov.mokksy.request.RequestSpecificationBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J+\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u0011J+\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u0011J\b\u0010\u0014\u001a\u00020\u000bH\u0016J/\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u0011H\u0002\u00a8\u0006\u0019"}, d2={"Lme/kpavlov/aimocks/gemini/MockGemini;", "Lme/kpavlov/aimocks/core/AbstractMockLlm;", "port", "", "verbose", "", "<init>", "(IZ)V", "generateContent", "Lme/kpavlov/aimocks/gemini/content/GeminiContentBuildingStep;", "name", "", "block", "Ljava/util/function/Consumer;", "Lme/kpavlov/aimocks/gemini/content/GeminiContentRequestSpecification;", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "generateContentStream", "Lme/kpavlov/aimocks/gemini/content/GeminiStreamingContentBuildingStep;", "baseUrl", "matchRequestSpec", "builder", "Lme/kpavlov/mokksy/request/RequestSpecificationBuilder;", "Lme/kpavlov/aimocks/gemini/GenerateContentRequest;", "ai-mocks-gemini"})
@SourceDebugExtension(value={"SMAP\nMockGemini.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockGemini.kt\nme/kpavlov/aimocks/gemini/MockGemini\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1869#2,2:167\n*S KotlinDebug\n*F\n+ 1 MockGemini.kt\nme/kpavlov/aimocks/gemini/MockGemini\n*L\n160#1:167,2\n*E\n"})
public class MockGemini
extends AbstractMockLlm {
    public MockGemini(int port, boolean verbose) {
        super(port, new ServerConfiguration(verbose, null, MockGemini::_init_$lambda$1, 2, null), null, 4, null);
    }

    public /* synthetic */ MockGemini(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        this(n, bl);
    }

    @JvmOverloads
    @NotNull
    public final GeminiContentBuildingStep generateContent(@Nullable String name, @NotNull Consumer<GeminiContentRequestSpecification> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return this.generateContent(name, (Function1<? super GeminiContentRequestSpecification, Unit>)((Function1)arg_0 -> MockGemini.generateContent$lambda$2(block, arg_0)));
    }

    public static /* synthetic */ GeminiContentBuildingStep generateContent$default(MockGemini mockGemini, String string, Consumer consumer, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateContent");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return mockGemini.generateContent(string, consumer);
    }

    @NotNull
    public final GeminiContentBuildingStep generateContent(@Nullable String name, @NotNull Function1<? super GeminiContentRequestSpecification, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        BuildingStep requestStep = this.getMokksy().post(name, Reflection.getOrCreateKotlinClass(GenerateContentRequest.class), arg_0 -> MockGemini.generateContent$lambda$3(this, block, arg_0));
        MokksyServer mokksyServer = this.getMokksy();
        return new GeminiContentBuildingStep(mokksyServer, (BuildingStep<GenerateContentRequest>)requestStep);
    }

    public static /* synthetic */ GeminiContentBuildingStep generateContent$default(MockGemini mockGemini, String string, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateContent");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return mockGemini.generateContent(string, (Function1<? super GeminiContentRequestSpecification, Unit>)function1);
    }

    @NotNull
    public final GeminiStreamingContentBuildingStep generateContentStream(@Nullable String name, @NotNull Function1<? super GeminiContentRequestSpecification, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        BuildingStep requestStep = this.getMokksy().post(name, Reflection.getOrCreateKotlinClass(GenerateContentRequest.class), arg_0 -> MockGemini.generateContentStream$lambda$4(this, block, arg_0));
        MokksyServer mokksyServer = this.getMokksy();
        return new GeminiStreamingContentBuildingStep(mokksyServer, (BuildingStep<GenerateContentRequest>)requestStep);
    }

    public static /* synthetic */ GeminiStreamingContentBuildingStep generateContentStream$default(MockGemini mockGemini, String string, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateContentStream");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return mockGemini.generateContentStream(string, (Function1<? super GeminiContentRequestSpecification, Unit>)function1);
    }

    @NotNull
    public String baseUrl() {
        return "http://localhost:" + this.port();
    }

    private final GeminiContentRequestSpecification matchRequestSpec(RequestSpecificationBuilder<GenerateContentRequest> builder, Function1<? super GeminiContentRequestSpecification, Unit> block) {
        GeminiContentRequestSpecification chatRequestSpec = new GeminiContentRequestSpecification(null, null, null, null, null, null, 63, null);
        block.invoke((Object)chatRequestSpec);
        CollectionsKt.addAll((Collection)builder.getBody(), (Iterable)chatRequestSpec.getRequestBody());
        Integer n = chatRequestSpec.getMaxOutputTokens();
        if (n != null) {
            int maxOutputTokens = ((Number)n).intValue();
            boolean bl = false;
            builder.bodyMatchesPredicate("Max output tokens should be " + maxOutputTokens + ".", arg_0 -> MockGemini.matchRequestSpec$lambda$6$lambda$5(maxOutputTokens, arg_0));
        }
        Number number = chatRequestSpec.getSeed();
        if (number != null) {
            Number seed = number;
            boolean bl = false;
            builder.bodyMatchesPredicate("Seed should be " + seed + ".", arg_0 -> MockGemini.matchRequestSpec$lambda$8$lambda$7(seed, arg_0));
        }
        Double d = chatRequestSpec.getTemperature();
        if (d != null) {
            double temperature = ((Number)d).doubleValue();
            boolean bl = false;
            builder.bodyMatchesPredicate("Temperature should be within 5.0E-8 of " + temperature + ".", arg_0 -> MockGemini.matchRequestSpec$lambda$10$lambda$9(temperature, arg_0));
        }
        Double d2 = chatRequestSpec.getTopP();
        if (d2 != null) {
            double topP = ((Number)d2).doubleValue();
            boolean bl = false;
            builder.bodyMatchesPredicate("topP should be within 5.0E-8 of " + topP + ".", arg_0 -> MockGemini.matchRequestSpec$lambda$12$lambda$11(topP, arg_0));
        }
        Long l = chatRequestSpec.getTopK();
        if (l != null) {
            long topK = ((Number)l).longValue();
            boolean bl = false;
            builder.bodyMatchesPredicate("Top K should be " + topK + ".", arg_0 -> MockGemini.matchRequestSpec$lambda$14$lambda$13(topK, arg_0));
        }
        Iterable $this$forEach$iv = chatRequestSpec.getRequestBodyString();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Matcher it = (Matcher)element$iv;
            boolean bl = false;
            ((Collection)builder.getBodyString()).add(it);
        }
        return chatRequestSpec;
    }

    @JvmOverloads
    @NotNull
    public final GeminiContentBuildingStep generateContent(@NotNull Consumer<GeminiContentRequestSpecification> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return MockGemini.generateContent$default(this, null, block, 1, null);
    }

    private static final Unit _init_$lambda$1$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ContentNegotiationConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        JsonSupportKt.json$default((Configuration)((Configuration)config), (Json)JsonKt.Json$default(null, MockGemini::_init_$lambda$1$lambda$0, (int)1, null), null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit generateContent$lambda$2(Consumer $block, GeminiContentRequestSpecification $this$generateContent) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$generateContent), (String)"$this$generateContent");
        $block.accept($this$generateContent);
        return Unit.INSTANCE;
    }

    private static final Unit generateContent$lambda$3(MockGemini this$0, Function1 $block, RequestSpecificationBuilder $this$post) {
        Intrinsics.checkNotNullParameter((Object)$this$post, (String)"$this$post");
        GeminiContentRequestSpecification chatRequestSpec = this$0.matchRequestSpec((RequestSpecificationBuilder<GenerateContentRequest>)$this$post, (Function1<? super GeminiContentRequestSpecification, Unit>)$block);
        String model = chatRequestSpec.getModel();
        Object object = chatRequestSpec.getPath();
        if (object == null) {
            object = "/" + chatRequestSpec.getApiVersion() + "/projects/" + chatRequestSpec.getProject() + "/locations/" + chatRequestSpec.getLocation() + "/publishers/google/models/" + model + ":generateContent";
        }
        String pathString = object;
        $this$post.path(pathString);
        return Unit.INSTANCE;
    }

    private static final Unit generateContentStream$lambda$4(MockGemini this$0, Function1 $block, RequestSpecificationBuilder $this$post) {
        Intrinsics.checkNotNullParameter((Object)$this$post, (String)"$this$post");
        GeminiContentRequestSpecification chatRequestSpec = this$0.matchRequestSpec((RequestSpecificationBuilder<GenerateContentRequest>)$this$post, (Function1<? super GeminiContentRequestSpecification, Unit>)$block);
        String model = chatRequestSpec.getModel();
        Object object = chatRequestSpec.getPath();
        if (object == null) {
            object = "/" + chatRequestSpec.getApiVersion() + "/projects/" + chatRequestSpec.getProject() + "/locations/" + chatRequestSpec.getLocation() + "/publishers/google/models/" + model + ":streamGenerateContent";
        }
        String pathString = object;
        $this$post.path(pathString);
        return Unit.INSTANCE;
    }

    private static final boolean matchRequestSpec$lambda$6$lambda$5(int $maxOutputTokens, GenerateContentRequest it) {
        boolean bl;
        Object object = it;
        if (object != null && (object = ((GenerateContentRequest)object).getGenerationConfig()) != null) {
            Integer n = ((GenerationConfig)object).getMaxOutputTokens();
            int n2 = $maxOutputTokens;
            bl = n != null && n == n2;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean matchRequestSpec$lambda$8$lambda$7(Number $seed, GenerateContentRequest it) {
        boolean bl;
        Object object = it;
        if (object != null && (object = ((GenerateContentRequest)object).getGenerationConfig()) != null) {
            Integer n = ((GenerationConfig)object).getSeed();
            int n2 = $seed.intValue();
            bl = n != null && n == n2;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean matchRequestSpec$lambda$10$lambda$9(double $temperature, GenerateContentRequest it) {
        Object object = it;
        Double requestTemperature = object != null && (object = ((GenerateContentRequest)object).getGenerationConfig()) != null ? ((GenerationConfig)object).getTemperature() : null;
        return requestTemperature != null && Math.abs(requestTemperature - $temperature) <= 5.0E-8;
    }

    private static final boolean matchRequestSpec$lambda$12$lambda$11(double $topP, GenerateContentRequest it) {
        Object object = it;
        Double value = object != null && (object = ((GenerateContentRequest)object).getGenerationConfig()) != null ? ((GenerationConfig)object).getTopP() : null;
        return value != null && Math.abs(value - $topP) <= 5.0E-8;
    }

    private static final boolean matchRequestSpec$lambda$14$lambda$13(long $topK, GenerateContentRequest it) {
        Object object = it;
        return object != null && (object = ((GenerateContentRequest)object).getGenerationConfig()) != null && (object = ((GenerationConfig)object).getTopK()) != null ? (long)((Float)object).floatValue() == $topK : false;
    }

    public MockGemini() {
        this(0, false, 3, null);
    }
}

