/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.ftp;

import android.net.TrafficStats;
import android.os.Process;
import android.text.TextUtils;
import aria.apache.commons.net.ftp.FTPClient;
import aria.apache.commons.net.ftp.FTPClientConfig;
import aria.apache.commons.net.ftp.FTPFile;
import aria.apache.commons.net.ftp.FTPReply;
import aria.apache.commons.net.ftp.FTPSClient;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.FtpUrlEntity;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.common.CompleteInfo;
import com.arialyy.aria.core.loader.IInfoTask;
import com.arialyy.aria.core.loader.ILoaderVisitor;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.exception.AriaFTPException;
import com.arialyy.aria.ftp.FtpTaskOption;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CheckUtil;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.SSLContextUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import javax.net.ssl.SSLContext;

public abstract class AbsFtpInfoTask<ENTITY extends AbsEntity, TASK_WRAPPER extends AbsTaskWrapper<ENTITY>>
implements Runnable,
IInfoTask {
    protected final String TAG = CommonUtil.getClassName(this.getClass());
    protected ENTITY mEntity;
    protected TASK_WRAPPER mTaskWrapper;
    protected FtpTaskOption mTaskOption;
    private int mConnectTimeOut;
    protected long mSize = 0L;
    protected String charSet = "UTF-8";
    private IInfoTask.Callback callback;
    private boolean isStop = false;
    private boolean isCancel = false;

    public AbsFtpInfoTask(TASK_WRAPPER taskWrapper) {
        this.mTaskWrapper = taskWrapper;
        this.mEntity = taskWrapper.getEntity();
        this.mTaskOption = (FtpTaskOption)taskWrapper.getTaskOption();
        this.mConnectTimeOut = AriaConfig.getInstance().getDConfig().getConnectTimeOut();
    }

    protected abstract String getRemotePath();

    protected abstract void handelFileInfo(FTPClient var1, FTPFile[] var2, String var3) throws IOException;

    public void stop() {
        this.isStop = true;
    }

    public void cancel() {
        this.isCancel = true;
    }

    public void setCallback(IInfoTask.Callback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        TrafficStats.setThreadStatsTag((int)UUID.randomUUID().toString().hashCode());
        FTPClient client = null;
        try {
            client = this.createFtpClient();
            if (client == null) {
                ALog.e((String)this.TAG, (String)String.format("\u4efb\u52a1\u3010%s\u3011\u5931\u8d25", this.mTaskOption.getUrlEntity().url));
                return;
            }
            String convertedRemotePath = CommonUtil.convertFtpChar((String)this.charSet, (String)this.getRemotePath());
            FTPFile[] files = client.listFiles(convertedRemotePath);
            this.handelFileInfo(client, files, convertedRemotePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.handleFail(client, "FTP\u9519\u8bef\u4fe1\u606f", e, true);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.handleFail(client, "FTP\u9519\u8bef\u4fe1\u606f", e, true);
        }
        finally {
            this.closeClient(client);
        }
    }

    protected boolean onInterceptor(FTPClient client, FTPFile[] ftpFiles) {
        return true;
    }

    protected void onPreComplete(int code) {
    }

    private FTPClient createFtpClient() throws IOException, InterruptedException {
        FTPClient client = null;
        FtpUrlEntity urlEntity = this.mTaskOption.getUrlEntity();
        if (CheckUtil.checkIp((String)urlEntity.hostName)) {
            client = this.newInstanceClient(urlEntity);
            client.setConnectTimeout(this.mConnectTimeOut);
            InetAddress ip = InetAddress.getByName(urlEntity.hostName);
            client = this.connect(client, new InetAddress[]{ip}, 0, Integer.parseInt(urlEntity.port));
            this.mTaskOption.getUrlEntity().validAddr = ip;
        } else {
            DNSQueryThread dnsThread = new DNSQueryThread(urlEntity.hostName);
            dnsThread.start();
            dnsThread.join(this.mConnectTimeOut);
            InetAddress[] ips = dnsThread.getIps();
            client = this.connect(this.newInstanceClient(urlEntity), ips, 0, Integer.parseInt(urlEntity.port));
        }
        if (client == null) {
            this.handleFail(client, String.format("\u94fe\u63a5\u5931\u8d25, url: %s", this.mTaskOption.getUrlEntity().url), null, true);
            return null;
        }
        boolean loginSuccess = true;
        if (urlEntity.needLogin) {
            try {
                loginSuccess = TextUtils.isEmpty((CharSequence)urlEntity.account) ? client.login(urlEntity.user, urlEntity.password) : client.login(urlEntity.user, urlEntity.password, urlEntity.account);
            }
            catch (IOException e) {
                e.printStackTrace();
                ALog.e((String)this.TAG, (String)String.format("\u767b\u5f55\u5931\u8d25\uff0c\u9519\u8bef\u7801\u4e3a\uff1a%s\uff0c msg\uff1a%s", client.getReplyCode(), client.getReplyString()));
                return null;
            }
        }
        if (!loginSuccess) {
            this.handleFail(client, "\u767b\u5f55\u5931\u8d25", null, false);
            client.disconnect();
            return null;
        }
        int reply = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            this.handleFail(client, String.format("\u65e0\u6cd5\u8fde\u63a5\u5230ftp\u670d\u52a1\u5668\uff0cfilePath: %s, url: %s", this.mEntity.getKey(), this.mTaskOption.getUrlEntity().url), null, true);
            client.disconnect();
            return null;
        }
        this.charSet = "UTF-8";
        reply = client.sendCommand("OPTS UTF8", "ON");
        if (reply != 202) {
            ALog.i((String)this.TAG, (String)"D_FTP \u670d\u52a1\u5668\u4e0d\u652f\u6301\u5f00\u542fUTF8\u7f16\u7801\uff0c\u5c1d\u8bd5\u4f7f\u7528Aria\u624b\u52a8\u8bbe\u7f6e\u7684\u7f16\u7801");
            if (!TextUtils.isEmpty((CharSequence)this.mTaskOption.getCharSet())) {
                this.charSet = this.mTaskOption.getCharSet();
            }
        }
        client.setControlEncoding(this.charSet);
        client.setDataTimeout(10000);
        if (this.mTaskOption.getConnMode() == 1) {
            client.enterLocalActiveMode();
            if (this.mTaskOption.getMinPort() != 0 && this.mTaskOption.getMaxPort() != 0) {
                client.setActivePortRange(this.mTaskOption.getMinPort(), this.mTaskOption.getMaxPort());
            }
            if (!TextUtils.isEmpty((CharSequence)this.mTaskOption.getActiveExternalIPAddress())) {
                client.setActiveExternalIPAddress(this.mTaskOption.getActiveExternalIPAddress());
            }
        } else {
            client.enterLocalPassiveMode();
        }
        client.setFileType(2);
        return client;
    }

    protected void closeClient(FTPClient client) {
        try {
            if (client != null && client.isConnected()) {
                client.logout();
                client.disconnect();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private FTPClient newInstanceClient(FtpUrlEntity urlEntity) {
        FTPClientConfig clientConfig;
        FTPClient temp;
        if (urlEntity.isFtps) {
            SSLContext sslContext = SSLContextUtil.getSSLContext((String)urlEntity.idEntity.keyAlias, (String)urlEntity.idEntity.storePath, (String)urlEntity.protocol);
            FTPSClient sClient = sslContext == null ? new FTPSClient(urlEntity.protocol, urlEntity.isImplicit) : new FTPSClient(true, sslContext);
            temp = sClient;
        } else {
            temp = new FTPClient();
        }
        if (this.mTaskOption.getClientConfig() != null) {
            clientConfig = this.mTaskOption.getClientConfig();
        } else {
            clientConfig = new FTPClientConfig("UNIX");
            clientConfig.setServerLanguageCode("en");
        }
        temp.configure(clientConfig);
        return temp;
    }

    private FTPClient connect(FTPClient client, InetAddress[] ips, int index, int port) {
        if (ips == null || ips.length == 0) {
            ALog.w((String)this.TAG, (String)"\u65e0\u53ef\u7528ip");
            return null;
        }
        try {
            client.setConnectTimeout(this.mConnectTimeOut);
            client.connect(ips[index], port);
            this.mTaskOption.getUrlEntity().validAddr = ips[index];
            FtpUrlEntity urlEntity = this.mTaskOption.getUrlEntity();
            if (urlEntity.isFtps) {
                FTPSClient sClient = (FTPSClient)client;
                sClient.execPBSZ(0L);
                sClient.execPROT("P");
            }
            return client;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.closeClient(client);
            if (index + 1 >= ips.length) {
                ALog.w((String)this.TAG, (String)"\u9047\u5230[ECONNREFUSED-\u8fde\u63a5\u88ab\u670d\u52a1\u5668\u62d2\u7edd]\u9519\u8bef\uff0c\u5df2\u6ca1\u6709\u5176\u4ed6\u5730\u5740\uff0c\u94fe\u63a5\u5931\u8d25\uff1b\u5982\u679c\u662fftps\uff0c\u8bf7\u68c0\u67e5\u7aef\u53e3\u662f\u5426\u4f7f\u7528\u4e86ftp\u7684\u7aef\u53e3\u800c\u4e0d\u662fftps\u7684\u7aef\u53e3");
                return null;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            ALog.w((String)this.TAG, (String)"\u9047\u5230[ECONNREFUSED-\u8fde\u63a5\u88ab\u670d\u52a1\u5668\u62d2\u7edd]\u9519\u8bef\uff0c\u6b63\u5728\u5c1d\u8bd5\u4e0b\u4e00\u4e2a\u5730\u5740");
            return this.connect(this.newInstanceClient(this.mTaskOption.getUrlEntity()), ips, index + 1, port);
        }
    }

    protected long getFileSize(FTPFile[] files, FTPClient client, String dirName) throws IOException {
        long size = 0L;
        String path = dirName + "/";
        for (FTPFile file : files) {
            if (file.isFile()) {
                size += file.getSize();
                this.handleFile(client, path + file.getName(), file);
                continue;
            }
            String remotePath = CommonUtil.convertFtpChar((String)this.charSet, (String)(path + file.getName()));
            size += this.getFileSize(client.listFiles(remotePath), client, path + file.getName());
        }
        return size;
    }

    protected void handleFile(FTPClient client, String remotePath, FTPFile ftpFile) {
    }

    protected void handleFail(FTPClient client, String msg, Exception e, boolean needRetry) {
        if (this.isStop || this.isCancel) {
            return;
        }
        if (this.callback != null) {
            if (client == null) {
                msg = "\u521b\u5efaftp\u5ba2\u6237\u7aef\u5931\u8d25";
                needRetry = false;
            } else {
                msg = String.format("%s, code: %s, msg: %s", msg, client.getReplyCode(), client.getReplyString());
                needRetry = needRetry && !CheckUtil.ftpIsBadRequest((int)client.getReplyCode());
            }
            this.callback.onFail(this.mEntity, (AriaException)new AriaFTPException(msg), needRetry);
        }
    }

    protected void onSucceed(CompleteInfo info) {
        this.callback.onSucceed(this.mEntity.getKey(), info);
    }

    public void accept(ILoaderVisitor visitor) {
        visitor.addComponent((IInfoTask)this);
    }

    private static class DNSQueryThread
    extends Thread {
        private String hostName;
        private InetAddress[] ips;

        DNSQueryThread(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public void run() {
            try {
                this.ips = InetAddress.getAllByName(this.hostName);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }

        synchronized InetAddress[] getIps() {
            return this.ips;
        }
    }
}

