/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.ftp;

import android.text.TextUtils;
import aria.apache.commons.net.ftp.FTPClient;
import aria.apache.commons.net.ftp.FTPClientConfig;
import aria.apache.commons.net.ftp.FTPReply;
import aria.apache.commons.net.ftp.FTPSClient;
import com.arialyy.aria.core.FtpUrlEntity;
import com.arialyy.aria.core.common.SubThreadConfig;
import com.arialyy.aria.core.task.AbsThreadTaskAdapter;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.exception.AriaFTPException;
import com.arialyy.aria.ftp.FtpTaskOption;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.SSLContextUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;

public abstract class BaseFtpThreadTaskAdapter
extends AbsThreadTaskAdapter {
    protected FtpTaskOption mTaskOption = (FtpTaskOption)this.getTaskWrapper().getTaskOption();
    protected String charSet;

    protected BaseFtpThreadTaskAdapter(SubThreadConfig config) {
        super(config);
    }

    protected void closeClient(FTPClient client) {
        try {
            if (client != null && client.isConnected()) {
                client.logout();
                client.disconnect();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected FTPClient createClient() {
        FTPClient client = null;
        FtpUrlEntity urlEntity = this.mTaskOption.getUrlEntity();
        if (urlEntity.validAddr == null) {
            try {
                InetAddress[] ips = InetAddress.getAllByName(urlEntity.hostName);
                client = this.connect(this.newInstanceClient(urlEntity), ips, 0, Integer.parseInt(urlEntity.port));
                if (client == null) {
                    return null;
                }
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        } else {
            client = this.newInstanceClient(urlEntity);
            try {
                client.connect(urlEntity.validAddr, Integer.parseInt(urlEntity.port));
            }
            catch (IOException e) {
                ALog.e((String)this.TAG, (String)ALog.getExceptionString((Throwable)e));
                return null;
            }
        }
        if (client == null) {
            return null;
        }
        try {
            int reply;
            if (urlEntity.isFtps) {
                FTPSClient sClient = (FTPSClient)client;
                sClient.execPBSZ(0L);
                sClient.execPROT("P");
            }
            if (urlEntity.needLogin) {
                if (TextUtils.isEmpty((CharSequence)urlEntity.account)) {
                    client.login(urlEntity.user, urlEntity.password);
                } else {
                    client.login(urlEntity.user, urlEntity.password, urlEntity.account);
                }
            }
            if (!FTPReply.isPositiveCompletion(reply = client.getReplyCode())) {
                client.disconnect();
                this.fail((AriaException)new AriaFTPException(String.format("\u65e0\u6cd5\u8fde\u63a5\u5230ftp\u670d\u52a1\u5668\uff0c\u9519\u8bef\u7801\u4e3a\uff1a%s\uff0cmsg:%s", reply, client.getReplyString())), false);
                return null;
            }
            this.charSet = "UTF-8";
            if (reply != 202 && !TextUtils.isEmpty((CharSequence)this.mTaskOption.getCharSet())) {
                this.charSet = this.mTaskOption.getCharSet();
            }
            client.setControlEncoding(this.charSet);
            client.setDataTimeout(1000);
            client.setConnectTimeout(this.getTaskConfig().getConnectTimeOut());
            if (this.mTaskOption.getConnMode() == 1) {
                client.enterLocalActiveMode();
                if (this.mTaskOption.getMinPort() != 0 && this.mTaskOption.getMaxPort() != 0) {
                    client.setActivePortRange(this.mTaskOption.getMinPort(), this.mTaskOption.getMaxPort());
                }
                if (!TextUtils.isEmpty((CharSequence)this.mTaskOption.getActiveExternalIPAddress())) {
                    client.setActiveExternalIPAddress(this.mTaskOption.getActiveExternalIPAddress());
                }
            } else {
                client.enterLocalPassiveMode();
            }
            client.setFileType(2);
            client.setControlKeepAliveTimeout(5000L);
        }
        catch (IOException e) {
            this.closeClient(client);
            e.printStackTrace();
        }
        return client;
    }

    private FTPClient newInstanceClient(FtpUrlEntity urlEntity) {
        FTPClientConfig clientConfig;
        FTPClient temp;
        if (urlEntity.isFtps) {
            SSLContext sslContext = SSLContextUtil.getSSLContext((String)urlEntity.idEntity.keyAlias, (String)urlEntity.idEntity.storePath, (String)urlEntity.protocol);
            FTPSClient sClient = sslContext == null ? new FTPSClient(urlEntity.protocol, urlEntity.isImplicit) : new FTPSClient(true, sslContext);
            temp = sClient;
        } else {
            temp = new FTPClient();
        }
        if (this.mTaskOption.getClientConfig() != null) {
            clientConfig = this.mTaskOption.getClientConfig();
        } else {
            clientConfig = new FTPClientConfig("UNIX");
            clientConfig.setServerLanguageCode("en");
        }
        temp.configure(clientConfig);
        return temp;
    }

    private FTPClient connect(FTPClient client, InetAddress[] ips, int index, int port) {
        try {
            client.connect(ips[index], port);
            this.mTaskOption.getUrlEntity().validAddr = ips[index];
            return client;
        }
        catch (IOException e) {
            try {
                if (client.isConnected()) {
                    client.disconnect();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (index + 1 >= ips.length) {
                ALog.w((String)this.TAG, (String)"\u9047\u5230[ECONNREFUSED-\u8fde\u63a5\u88ab\u670d\u52a1\u5668\u62d2\u7edd]\u9519\u8bef\uff0c\u5df2\u6ca1\u6709\u5176\u4ed6\u5730\u5740\uff0c\u94fe\u63a5\u5931\u8d25");
                return null;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            ALog.w((String)this.TAG, (String)"\u9047\u5230[ECONNREFUSED-\u8fde\u63a5\u88ab\u670d\u52a1\u5668\u62d2\u7edd]\u9519\u8bef\uff0c\u6b63\u5728\u5c1d\u8bd5\u4e0b\u4e00\u4e2a\u5730\u5740");
            return this.connect(new FTPClient(), ips, index + 1, port);
        }
    }
}

