/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.ftp.download;

import aria.apache.commons.net.ftp.FTPClient;
import aria.apache.commons.net.ftp.FTPFile;
import aria.apache.commons.net.ftp.FTPReply;
import com.arialyy.aria.core.common.CompleteInfo;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.wrapper.ITaskWrapper;
import com.arialyy.aria.exception.AriaFTPException;
import com.arialyy.aria.ftp.AbsFtpInfoTask;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.FileUtil;
import java.io.File;
import java.io.IOException;

final class FtpDFileInfoTask
extends AbsFtpInfoTask<DownloadEntity, DTaskWrapper> {
    FtpDFileInfoTask(DTaskWrapper taskEntity) {
        super(taskEntity);
    }

    @Override
    protected void handleFile(FTPClient client, String remotePath, FTPFile ftpFile) {
        super.handleFile(client, remotePath, ftpFile);
        if (!FileUtil.checkMemorySpace((String)((DownloadEntity)this.mEntity).getFilePath(), (long)ftpFile.getSize())) {
            this.handleFail(client, "\u5185\u5b58\u7a7a\u95f4\u4e0d\u8db3", (Exception)new AriaFTPException(String.format("\u83b7\u53d6ftp\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c\u5185\u5b58\u7a7a\u95f4\u4e0d\u8db3, filePath: %s", ((DownloadEntity)this.mEntity).getFilePath())), false);
        }
    }

    @Override
    protected void handelFileInfo(FTPClient client, FTPFile[] files, String convertedRemotePath) throws IOException {
        boolean isExist;
        boolean bl = isExist = files.length != 0;
        if (!isExist) {
            int i = convertedRemotePath.lastIndexOf(File.separator);
            FTPFile[] files1 = i == -1 ? client.listFiles() : client.listFiles(convertedRemotePath.substring(0, i + 1));
            if (files1.length > 0) {
                ALog.i((String)this.TAG, (String)String.format("\u8def\u5f84\u3010%s\u3011\u4e0b\u7684\u6587\u4ef6\u5217\u8868 ===================================", this.getRemotePath()));
                for (FTPFile file : files1) {
                    ALog.d((String)this.TAG, (String)file.toString());
                }
                ALog.i((String)this.TAG, (String)"================================= --end-- ===================================");
            } else {
                ALog.w((String)this.TAG, (String)String.format("\u83b7\u53d6\u6587\u4ef6\u5217\u8868\u5931\u8d25\uff0cmsg\uff1a%s", client.getReplyString()));
            }
            this.closeClient(client);
            this.handleFail(client, String.format("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0curl: %s, remotePath\uff1a%s", this.mTaskOption.getUrlEntity().url, this.getRemotePath()), null, false);
            return;
        }
        if (!this.onInterceptor(client, files)) {
            this.closeClient(client);
            ALog.d((String)this.TAG, (String)"\u62e6\u622a\u5668\u5904\u7406\u5b8c\u6210\u4efb\u52a1");
            return;
        }
        this.mSize = this.getFileSize(files, client, this.getRemotePath());
        int reply = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            this.closeClient(client);
            this.handleFail(client, "\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u9519\u8bef\uff0curl: " + this.mTaskOption.getUrlEntity().url, null, true);
            return;
        }
        ((DTaskWrapper)this.mTaskWrapper).setCode(reply);
        if (this.mSize != 0L) {
            ((DownloadEntity)this.mEntity).setFileSize(this.mSize);
        }
        this.onPreComplete(reply);
        ((DownloadEntity)this.mEntity).update();
    }

    @Override
    protected String getRemotePath() {
        return this.mTaskOption.getUrlEntity().remotePath;
    }

    @Override
    protected void onPreComplete(int code) {
        ALog.i((String)this.TAG, (String)"FTP\u4e0b\u8f7d\u9884\u5904\u7406\u5b8c\u6210");
        super.onPreComplete(code);
        if (this.mSize != ((DownloadEntity)((DTaskWrapper)this.mTaskWrapper).getEntity()).getFileSize()) {
            ((DTaskWrapper)this.mTaskWrapper).setNewTask(true);
        }
        ((DownloadEntity)this.mEntity).setFileSize(this.mSize);
        this.onSucceed(new CompleteInfo(code, (ITaskWrapper)this.mTaskWrapper));
    }
}

