/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.ftp.download;

import android.net.Uri;
import android.text.TextUtils;
import aria.apache.commons.net.ftp.FTPClient;
import aria.apache.commons.net.ftp.FTPFile;
import aria.apache.commons.net.ftp.FTPReply;
import com.arialyy.aria.core.FtpUrlEntity;
import com.arialyy.aria.core.common.CompleteInfo;
import com.arialyy.aria.core.download.DGTaskWrapper;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.core.inf.ITaskOption;
import com.arialyy.aria.core.wrapper.ITaskWrapper;
import com.arialyy.aria.ftp.AbsFtpInfoTask;
import com.arialyy.aria.ftp.FtpTaskOption;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.DeleteDGRecord;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;

final class FtpDGInfoTask
extends AbsFtpInfoTask<DownloadGroupEntity, DGTaskWrapper> {
    FtpDGInfoTask(DGTaskWrapper wrapper) {
        super(wrapper);
    }

    @Override
    public void run() {
        if (((DownloadGroupEntity)((DGTaskWrapper)this.mTaskWrapper).getEntity()).getFileSize() > 1L && this.checkSubOption()) {
            this.onSucceed(new CompleteInfo(200, (ITaskWrapper)this.mTaskWrapper));
        } else {
            super.run();
        }
    }

    @Override
    protected void handelFileInfo(FTPClient client, FTPFile[] files, String convertedRemotePath) throws IOException {
        boolean isExist;
        boolean bl = isExist = files.length != 0;
        if (!isExist) {
            int i = convertedRemotePath.lastIndexOf(File.separator);
            FTPFile[] files1 = i == -1 ? client.listFiles() : client.listFiles(convertedRemotePath.substring(0, i + 1));
            if (files1.length > 0) {
                ALog.i((String)this.TAG, (String)String.format("\u8def\u5f84\u3010%s\u3011\u4e0b\u7684\u6587\u4ef6\u5217\u8868 ===================================", this.getRemotePath()));
                for (FTPFile file : files1) {
                    ALog.d((String)this.TAG, (String)file.toString());
                }
                ALog.i((String)this.TAG, (String)"================================= --end-- ===================================");
            } else {
                ALog.w((String)this.TAG, (String)String.format("\u83b7\u53d6\u6587\u4ef6\u5217\u8868\u5931\u8d25\uff0cmsg\uff1a%s", client.getReplyString()));
            }
            this.closeClient(client);
            this.handleFail(client, String.format("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0curl: %s, remotePath\uff1a%s", this.mTaskOption.getUrlEntity().url, this.getRemotePath()), null, false);
            return;
        }
        if (!this.onInterceptor(client, files)) {
            this.closeClient(client);
            ALog.d((String)this.TAG, (String)"\u62e6\u622a\u5668\u5904\u7406\u5b8c\u6210\u4efb\u52a1");
            return;
        }
        this.mSize = this.getFileSize(files, client, this.getRemotePath());
        int reply = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            this.closeClient(client);
            this.handleFail(client, "\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u9519\u8bef\uff0curl: " + this.mTaskOption.getUrlEntity().url, null, true);
            return;
        }
        ((DGTaskWrapper)this.mTaskWrapper).setCode(reply);
        if (this.mSize != 0L) {
            ((DownloadGroupEntity)this.mEntity).setFileSize(this.mSize);
        }
        this.onPreComplete(reply);
        ((DownloadGroupEntity)this.mEntity).update();
    }

    private boolean checkSubOption() {
        for (DTaskWrapper wrapper : ((DGTaskWrapper)this.mTaskWrapper).getSubTaskWrapper()) {
            if (wrapper.getTaskOption() != null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getRemotePath() {
        return this.mTaskOption.getUrlEntity().remotePath;
    }

    @Override
    protected void handleFile(FTPClient client, String remotePath, FTPFile ftpFile) {
        super.handleFile(client, remotePath, ftpFile);
        this.addEntity(remotePath, ftpFile);
    }

    @Override
    protected void onPreComplete(int code) {
        super.onPreComplete(code);
        ((DownloadGroupEntity)this.mEntity).setFileSize(this.mSize);
        for (DTaskWrapper wrapper : ((DGTaskWrapper)this.mTaskWrapper).getSubTaskWrapper()) {
            this.cloneInfo(wrapper);
        }
        this.onSucceed(new CompleteInfo(code, (ITaskWrapper)this.mTaskWrapper));
    }

    private void cloneInfo(DTaskWrapper subWrapper) {
        FtpTaskOption option = (FtpTaskOption)((DGTaskWrapper)this.mTaskWrapper).getTaskOption();
        FtpUrlEntity urlEntity = option.getUrlEntity().clone();
        Uri uri = Uri.parse((String)((DownloadEntity)subWrapper.getEntity()).getUrl());
        String remotePath = uri.getPath();
        urlEntity.remotePath = TextUtils.isEmpty((CharSequence)remotePath) ? "/" : remotePath;
        FtpTaskOption subOption = new FtpTaskOption();
        subOption.setUrlEntity(urlEntity);
        subOption.setCharSet(option.getCharSet());
        subOption.setProxy(option.getProxy());
        subOption.setClientConfig(option.getClientConfig());
        subOption.setNewFileName(option.getNewFileName());
        subOption.setProxy(option.getProxy());
        subOption.setUploadInterceptor(option.getUploadInterceptor());
        subWrapper.setTaskOption((ITaskOption)subOption);
    }

    private void addEntity(String remotePath, FTPFile ftpFile) {
        FtpUrlEntity urlEntity = this.mTaskOption.getUrlEntity().clone();
        String url = urlEntity.scheme + "://" + urlEntity.hostName + ":" + urlEntity.port + "/" + remotePath;
        if (this.checkEntityExist(url)) {
            ALog.w((String)this.TAG, (String)("\u5b50\u4efb\u52a1\u5df2\u5b58\u5728\uff0c\u53d6\u6d88\u5b50\u4efb\u52a1\u7684\u6dfb\u52a0\uff0curl = " + url));
            return;
        }
        DownloadEntity entity = new DownloadEntity();
        entity.setUrl(url);
        entity.setFilePath(((DownloadGroupEntity)this.mEntity).getDirPath() + "/" + remotePath);
        int lastIndex = remotePath.lastIndexOf("/");
        String fileName = lastIndex < 0 ? CommonUtil.keyToHashKey((String)remotePath) : remotePath.substring(lastIndex + 1);
        entity.setFileName(new String(fileName.getBytes(), Charset.forName(this.mTaskOption.getCharSet())));
        entity.setGroupHash(((DownloadGroupEntity)this.mEntity).getGroupHash());
        entity.setGroupChild(true);
        entity.setConvertFileSize(CommonUtil.formatFileSize((double)ftpFile.getSize()));
        entity.setFileSize(ftpFile.getSize());
        if (DbEntity.checkDataExist(DownloadEntity.class, (String[])new String[]{"downloadPath=?", entity.getFilePath()})) {
            DbEntity.deleteData(DownloadEntity.class, (String[])new String[]{"downloadPath=?", entity.getFilePath()});
        }
        entity.insert();
        DTaskWrapper subWrapper = new DTaskWrapper(entity);
        subWrapper.setGroupTask(true);
        subWrapper.setGroupHash(((DownloadGroupEntity)this.mEntity).getGroupHash());
        subWrapper.setRequestType(3);
        urlEntity.url = entity.getUrl();
        urlEntity.remotePath = remotePath;
        this.cloneInfo(subWrapper, urlEntity);
        if (((DownloadGroupEntity)this.mEntity).getUrls() == null) {
            ((DownloadGroupEntity)this.mEntity).setUrls(new ArrayList());
        }
        ((DownloadGroupEntity)this.mEntity).getSubEntities().add(entity);
        ((DGTaskWrapper)this.mTaskWrapper).getSubTaskWrapper().add(subWrapper);
    }

    private void cloneInfo(DTaskWrapper subWrapper, FtpUrlEntity urlEntity) {
        FtpTaskOption subOption = new FtpTaskOption();
        subOption.setUrlEntity(urlEntity);
        subOption.setCharSet(this.mTaskOption.getCharSet());
        subOption.setProxy(this.mTaskOption.getProxy());
        subOption.setClientConfig(this.mTaskOption.getClientConfig());
        subOption.setNewFileName(this.mTaskOption.getNewFileName());
        subOption.setProxy(this.mTaskOption.getProxy());
        subOption.setUploadInterceptor(this.mTaskOption.getUploadInterceptor());
        subWrapper.setTaskOption((ITaskOption)subOption);
    }

    private boolean checkEntityExist(String key) {
        for (DTaskWrapper wrapper : ((DGTaskWrapper)this.mTaskWrapper).getSubTaskWrapper()) {
            if (!wrapper.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void handleFail(FTPClient client, String msg, Exception e, boolean needRetry) {
        super.handleFail(client, msg, e, needRetry);
        DeleteDGRecord.getInstance().deleteRecord(((DGTaskWrapper)this.mTaskWrapper).getEntity(), true, true);
    }
}

