/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.ftp.download;

import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.RecordHandler;
import com.arialyy.aria.core.common.RecordHelper;
import com.arialyy.aria.core.config.Configuration;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.util.RecordUtil;
import java.util.ArrayList;

final class FtpDRecordHandler
extends RecordHandler {
    FtpDRecordHandler(DTaskWrapper wrapper) {
        super((AbsTaskWrapper)wrapper);
    }

    public void handlerTaskRecord(TaskRecord record) {
        RecordHelper helper = new RecordHelper(this.getWrapper(), record);
        if (record.threadNum == 1) {
            helper.handleSingleThreadRecord();
        } else if (this.getWrapper().isSupportBP()) {
            if (record.isBlock) {
                helper.handleBlockRecord();
            } else {
                helper.handleMultiRecord();
            }
        }
    }

    public ThreadRecord createThreadRecord(TaskRecord record, int threadId, long startL, long endL) {
        ThreadRecord tr = new ThreadRecord();
        tr.taskKey = record.filePath;
        tr.threadId = threadId;
        tr.startLocation = startL;
        tr.isComplete = false;
        tr.threadType = record.taskType;
        if (threadId == record.threadNum - 1) {
            endL = this.getFileSize();
        }
        tr.endLocation = endL;
        tr.blockLen = RecordUtil.getBlockLen((long)this.getFileSize(), (int)threadId, (int)record.threadNum);
        return tr;
    }

    public TaskRecord createTaskRecord(int threadNum) {
        TaskRecord record = new TaskRecord();
        record.fileName = this.getEntity().getFileName();
        record.filePath = this.getEntity().getFilePath();
        record.threadRecords = new ArrayList();
        record.threadNum = threadNum;
        record.isBlock = Configuration.getInstance().downloadCfg.isUseBlock();
        record.taskType = 3;
        record.isGroupRecord = false;
        return record;
    }

    public int initTaskThreadNum() {
        int threadNum = Configuration.getInstance().downloadCfg.getThreadNum();
        return this.getFileSize() <= 0x100000L || threadNum == 1 ? 1 : threadNum;
    }
}

