/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.ftp.upload;

import android.text.TextUtils;
import aria.apache.commons.net.ftp.FTPClient;
import aria.apache.commons.net.ftp.FTPFile;
import aria.apache.commons.net.ftp.FTPReply;
import com.arialyy.aria.core.common.CompleteInfo;
import com.arialyy.aria.core.processor.FtpInterceptHandler;
import com.arialyy.aria.core.processor.IFtpUploadInterceptor;
import com.arialyy.aria.core.upload.UTaskWrapper;
import com.arialyy.aria.core.upload.UploadEntity;
import com.arialyy.aria.core.wrapper.ITaskWrapper;
import com.arialyy.aria.ftp.AbsFtpInfoTask;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.io.IOException;
import java.util.ArrayList;

final class FtpUFileInfoTask
extends AbsFtpInfoTask<UploadEntity, UTaskWrapper> {
    static final int CODE_COMPLETE = 2737;
    private boolean isComplete = false;
    private String remotePath;
    private FTPFile ftpFile;

    FtpUFileInfoTask(UTaskWrapper taskEntity) {
        super(taskEntity);
    }

    @Override
    protected String getRemotePath() {
        return this.remotePath == null ? this.mTaskOption.getUrlEntity().remotePath + "/" + ((UploadEntity)this.mEntity).getFileName() : this.remotePath;
    }

    @Override
    protected void handelFileInfo(FTPClient client, FTPFile[] files, String convertedRemotePath) throws IOException {
        if (!this.onInterceptor(client, files)) {
            this.closeClient(client);
            ALog.d((String)this.TAG, (String)"\u62e6\u622a\u5668\u5904\u7406\u5b8c\u6210\u4efb\u52a1");
            return;
        }
        this.handleFile(client, this.getRemotePath(), files.length == 0 ? null : files[0]);
        int reply = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            ((UTaskWrapper)this.mTaskWrapper).setNewTask(true);
        }
        ((UTaskWrapper)this.mTaskWrapper).setCode(reply);
        this.onPreComplete(reply);
        ((UploadEntity)this.mEntity).update();
    }

    @Override
    protected boolean onInterceptor(FTPClient client, FTPFile[] ftpFiles) {
        try {
            IFtpUploadInterceptor interceptor = this.mTaskOption.getUploadInterceptor();
            if (interceptor != null) {
                ArrayList<String> files = new ArrayList<String>();
                for (FTPFile ftpFile : ftpFiles) {
                    if (ftpFile.isDirectory()) continue;
                    files.add(ftpFile.getName());
                }
                FtpInterceptHandler interceptHandler = interceptor.onIntercept((UploadEntity)this.mEntity, files);
                if (files.contains(((UploadEntity)this.mEntity).getFileName())) {
                    if (interceptHandler.isCoverServerFile()) {
                        ALog.i((String)this.TAG, (String)String.format("\u8fdc\u7aef\u5df2\u62e5\u6709\u540c\u540d\u6587\u4ef6\uff0c\u5c06\u8986\u76d6\u8be5\u6587\u4ef6\uff0c\u6587\u4ef6\u540d\uff1a%s", ((UploadEntity)this.mEntity).getFileName()));
                        boolean b = client.deleteFile(CommonUtil.convertFtpChar((String)this.charSet, (String)this.getRemotePath()));
                        ALog.d((String)this.TAG, (String)String.format("\u5220\u9664\u6587\u4ef6%s\uff0ccode: %s\uff0c msg: %s", b ? "\u6210\u529f" : "\u5931\u8d25", client.getReplyCode(), client.getReplyString()));
                    } else if (!TextUtils.isEmpty((CharSequence)interceptHandler.getNewFileName())) {
                        ALog.i((String)this.TAG, (String)String.format("\u8fdc\u7aef\u5df2\u62e5\u6709\u540c\u540d\u6587\u4ef6\uff0c\u5c06\u4fee\u6539remotePath\uff0c\u539f\u6587\u4ef6\u540d\uff1a%s\uff0c\u65b0\u6587\u4ef6\u540d\uff1a%s", ((UploadEntity)this.mEntity).getFileName(), interceptHandler.getNewFileName()));
                        this.remotePath = this.mTaskOption.getUrlEntity().remotePath + "/" + interceptHandler.getNewFileName();
                        this.mTaskOption.setNewFileName(interceptHandler.getNewFileName());
                        this.closeClient(client);
                        this.run();
                        return false;
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    protected void handleFile(FTPClient client, String remotePath, FTPFile ftpFile) {
        super.handleFile(client, remotePath, ftpFile);
        this.ftpFile = ftpFile;
        if (ftpFile != null && ftpFile.getSize() == ((UploadEntity)this.mEntity).getFileSize()) {
            this.isComplete = true;
        }
    }

    @Override
    protected void onPreComplete(int code) {
        super.onPreComplete(code);
        CompleteInfo info = new CompleteInfo(this.isComplete ? 2737 : code, (ITaskWrapper)this.mTaskWrapper);
        info.obj = this.ftpFile;
        this.onSucceed(info);
    }
}

