/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.ftp.upload;

import android.os.Handler;
import aria.apache.commons.net.ftp.FTPFile;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.common.CompleteInfo;
import com.arialyy.aria.core.listener.IEventListener;
import com.arialyy.aria.core.loader.IInfoTask;
import com.arialyy.aria.core.loader.IRecordHandler;
import com.arialyy.aria.core.loader.NormalLoader;
import com.arialyy.aria.core.manager.ThreadTaskManager;
import com.arialyy.aria.core.task.IThreadTask;
import com.arialyy.aria.core.upload.UTaskWrapper;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.ftp.upload.FtpURecordHandler;

final class FtpULoader
extends NormalLoader<UTaskWrapper> {
    private FTPFile ftpFile;

    FtpULoader(UTaskWrapper wrapper, IEventListener listener) {
        super((AbsTaskWrapper)wrapper, listener);
    }

    protected void startThreadTask() {
        if (this.isBreak()) {
            return;
        }
        ((FtpURecordHandler)this.mRecordHandler).setFtpFile(this.ftpFile);
        if (this.mRecordHandler.checkTaskCompleted()) {
            this.mRecord.deleteData();
            this.isComplete = true;
            this.getListener().onComplete();
            return;
        }
        this.mRecord = this.mRecordHandler.getRecord(this.getFileSize());
        this.mStateManager.setLooper(this.mRecord, this.getLooper());
        this.getTaskList().addAll(this.mTTBuilder.buildThreadTask(this.mRecord, new Handler(this.getLooper(), this.mStateManager.getHandlerCallback())));
        this.mStateManager.updateCurrentProgress(this.getEntity().getCurrentProgress());
        if (this.mStateManager.getCurrentProgress() > 0L) {
            this.getListener().onResume(this.mStateManager.getCurrentProgress());
        } else {
            this.getListener().onStart(this.mStateManager.getCurrentProgress());
        }
        this.startTimer();
        for (IThreadTask threadTask : this.getTaskList()) {
            ThreadTaskManager.getInstance().startThread(((UTaskWrapper)this.mTaskWrapper).getKey(), threadTask);
        }
    }

    public void addComponent(IInfoTask infoTask) {
        this.mInfoTask = infoTask;
        infoTask.setCallback(new IInfoTask.Callback(){

            public void onSucceed(String key, CompleteInfo info) {
                if (info.code == 2737) {
                    FtpULoader.this.getListener().onComplete();
                } else {
                    FtpULoader.this.ftpFile = (FTPFile)info.obj;
                    FtpULoader.this.startThreadTask();
                }
            }

            public void onFail(AbsEntity entity, AriaException e, boolean needRetry) {
                FtpULoader.this.getListener().onFail(needRetry, e);
            }
        });
    }

    public void addComponent(IRecordHandler recordHandler) {
        this.mRecordHandler = recordHandler;
    }
}

