/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.ftp.upload;

import aria.apache.commons.net.ftp.FTPFile;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.RecordHandler;
import com.arialyy.aria.core.upload.UTaskWrapper;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.RecordUtil;
import java.util.ArrayList;

final class FtpURecordHandler
extends RecordHandler {
    private FTPFile ftpFile;

    FtpURecordHandler(UTaskWrapper wrapper) {
        super((AbsTaskWrapper)wrapper);
    }

    void setFtpFile(FTPFile ftpFile) {
        this.ftpFile = ftpFile;
    }

    public void handlerTaskRecord(TaskRecord record) {
        if (record.threadRecords == null || record.threadRecords.isEmpty()) {
            record.threadRecords = new ArrayList();
            record.threadRecords.add(this.createThreadRecord(record, 0, this.ftpFile == null ? 0L : this.ftpFile.getSize(), this.getFileSize()));
        }
        if (this.ftpFile != null) {
            if (this.ftpFile.getSize() == this.getFileSize()) {
                ((ThreadRecord)record.threadRecords.get((int)0)).isComplete = true;
                ALog.d((String)this.TAG, (String)("FTP\u670d\u52a1\u5668\u4e0a\u5df2\u5b58\u5728\u8be5\u6587\u4ef6\u3010" + this.ftpFile.getName() + "\u3011"));
            } else if (this.ftpFile.getSize() == 0L) {
                this.getWrapper().setNewTask(true);
                ALog.d((String)this.TAG, (String)("FTP\u670d\u52a1\u5668\u4e0a\u5df2\u5b58\u5728\u8be5\u6587\u4ef6\u3010" + this.ftpFile.getName() + "\u3011\uff0c\u4f46\u6587\u4ef6\u957f\u5ea6\u4e3a0\uff0c\u91cd\u65b0\u4e0a\u4f20\u8be5\u6587\u4ef6"));
            } else {
                ALog.w((String)this.TAG, (String)("FTP\u670d\u52a1\u5668\u5df2\u5b58\u5728\u672a\u5b8c\u6210\u7684\u6587\u4ef6\u3010" + this.ftpFile.getName() + "\uff0csize: " + this.ftpFile.getSize() + "\u3011\u5c1d\u8bd5\u4ece\u4f4d\u7f6e\uff1a" + (this.ftpFile.getSize() - 1L) + "\u5f00\u59cb\u4e0a\u4f20"));
                this.getWrapper().setNewTask(false);
                ThreadRecord threadRecord = (ThreadRecord)record.threadRecords.get(0);
                threadRecord.startLocation = this.ftpFile.getSize() - 1L;
            }
        } else {
            ALog.d((String)this.TAG, (String)"FTP\u670d\u52a1\u5668\u4e0a\u4e0d\u5b58\u5728\u8be5\u6587\u4ef6");
            this.getWrapper().setNewTask(true);
            ThreadRecord tr = (ThreadRecord)record.threadRecords.get(0);
            tr.startLocation = 0L;
            tr.endLocation = this.getFileSize();
            tr.isComplete = false;
        }
    }

    public ThreadRecord createThreadRecord(TaskRecord record, int threadId, long startL, long endL) {
        ThreadRecord tr = new ThreadRecord();
        tr.taskKey = record.filePath;
        tr.threadId = threadId;
        tr.startLocation = startL;
        tr.isComplete = false;
        tr.threadType = record.taskType;
        tr.endLocation = this.getFileSize();
        tr.blockLen = RecordUtil.getBlockLen((long)this.getFileSize(), (int)threadId, (int)record.threadNum);
        return tr;
    }

    public TaskRecord createTaskRecord(int threadNum) {
        TaskRecord record = new TaskRecord();
        record.fileName = this.getEntity().getFileName();
        record.filePath = this.getEntity().getFilePath();
        record.threadRecords = new ArrayList();
        record.threadNum = threadNum;
        record.isBlock = false;
        record.taskType = 6;
        record.isGroupRecord = this.getEntity().isGroupChild();
        return record;
    }

    public int initTaskThreadNum() {
        return 1;
    }
}

