/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.ftp.upload;

import android.text.TextUtils;
import aria.apache.commons.net.ftp.FTPClient;
import aria.apache.commons.net.ftp.FTPReply;
import aria.apache.commons.net.ftp.OnFtpInputStreamListener;
import com.arialyy.aria.core.common.SubThreadConfig;
import com.arialyy.aria.core.upload.UploadEntity;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.exception.AriaFTPException;
import com.arialyy.aria.ftp.BaseFtpThreadTaskAdapter;
import com.arialyy.aria.ftp.upload.FtpFISAdapter;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.BufferedRandomAccessFile;
import com.arialyy.aria.util.CommonUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class FtpUThreadTaskAdapter
extends BaseFtpThreadTaskAdapter {
    private String dir;
    private String remotePath;
    private boolean storeSuccess = false;
    private ScheduledThreadPoolExecutor timer;
    private FTPClient client = null;
    private boolean isTimeOut = true;
    private FtpFISAdapter fa;

    FtpUThreadTaskAdapter(SubThreadConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlerThreadTask() {
        BufferedRandomAccessFile file = null;
        try {
            ALog.d((String)this.TAG, (String)String.format("\u4efb\u52a1\u3010%s\u3011\u7ebf\u7a0b__%s__\u5f00\u59cb\u4e0a\u4f20\u3010\u5f00\u59cb\u4f4d\u7f6e : %s\uff0c\u7ed3\u675f\u4f4d\u7f6e\uff1a%s\u3011", this.getEntity().getKey(), this.getThreadRecord().threadId, this.getThreadRecord().startLocation, this.getThreadRecord().endLocation));
            this.client = this.createClient();
            if (this.client == null) {
                return;
            }
            this.initPath();
            boolean b = this.client.makeDirectory(this.dir);
            if (!b) {
                ALog.w((String)this.TAG, (String)String.format("\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff0c\u9519\u8bef\u7801\u4e3a\uff1a%s, msg\uff1a%s", this.client.getReplyCode(), this.client.getReplyString()));
            }
            this.client.changeWorkingDirectory(this.dir);
            this.client.setRestartOffset(this.getThreadRecord().startLocation);
            int reply = this.client.getReplyCode();
            if (!FTPReply.isPositivePreliminary(reply) && reply != 250) {
                this.fail((AriaException)new AriaFTPException(String.format("\u6587\u4ef6\u4e0a\u4f20\u9519\u8bef\uff0c\u9519\u8bef\u7801\u4e3a\uff1a%s, msg\uff1a%s, filePath: %s", reply, this.client.getReplyString(), this.getEntity().getFilePath())), false);
                this.client.disconnect();
                return;
            }
            file = new BufferedRandomAccessFile(this.getThreadConfig().tempFile, "rwd", this.getTaskConfig().getBuffSize());
            if (this.getThreadRecord().startLocation > 0L) {
                file.seek(this.getThreadRecord().startLocation);
            }
            boolean complete = this.upload(file);
            if (this.getThreadTask().isBreak()) {
                return;
            }
            if (!complete) {
                this.fail((AriaException)new AriaFTPException("ftp\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"), false);
                return;
            }
            ALog.i((String)this.TAG, (String)String.format("\u4efb\u52a1\u3010%s\u3011\u7ebf\u7a0b__%s__\u4e0a\u4f20\u5b8c\u6bd5", this.getEntity().getKey(), this.getThreadRecord().threadId));
            this.complete();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.fail((AriaException)new AriaFTPException(String.format("\u4e0a\u4f20\u5931\u8d25\uff0cfilePath: %s, uploadUrl: %s", this.getEntity().getFilePath(), this.getThreadConfig().url)), true);
        }
        catch (Exception e) {
            this.fail((AriaException)new AriaFTPException(null, e), false);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.closeClient(this.client);
            this.closeTimer();
        }
    }

    private UploadEntity getEntity() {
        return (UploadEntity)this.getTaskWrapper().getEntity();
    }

    private void initPath() throws UnsupportedEncodingException {
        this.dir = CommonUtil.convertFtpChar((String)this.charSet, (String)this.mTaskOption.getUrlEntity().remotePath);
        String fileName = TextUtils.isEmpty((CharSequence)this.mTaskOption.getNewFileName()) ? this.getEntity().getFileName() : this.mTaskOption.getNewFileName();
        this.remotePath = CommonUtil.convertFtpChar((String)this.charSet, (String)String.format("%s/%s", this.mTaskOption.getUrlEntity().remotePath, fileName));
    }

    private void startTimer() {
        this.timer = new ScheduledThreadPoolExecutor(1);
        this.timer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    if (FtpUThreadTaskAdapter.this.isTimeOut) {
                        FtpUThreadTaskAdapter.this.fail((AriaException)new AriaFTPException("socket\u8fde\u63a5\u5931\u8d25\uff0c\u8be5\u95ee\u9898\u4e00\u822c\u51fa\u73b0\u4e8e\u7f51\u7edc\u65ad\u5f00\uff0c\u5ba2\u6237\u7aef\u91cd\u65b0\u8fde\u63a5\uff0c\u4f46\u662f\u670d\u52a1\u5668\u7aef\u65e0\u6cd5\u521b\u5efasocket\u7f3a\u6ca1\u6709\u8fd4\u56de\u9519\u8bef\u7801\u7684\u60c5\u51b5\u3002"), false);
                        if (FtpUThreadTaskAdapter.this.fa != null) {
                            FtpUThreadTaskAdapter.this.fa.close();
                        }
                        FtpUThreadTaskAdapter.this.closeTimer();
                    }
                    FtpUThreadTaskAdapter.this.isTimeOut = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    private void closeTimer() {
        ALog.d((String)this.TAG, (String)"closeTimer");
        if (this.timer != null && !this.timer.isShutdown()) {
            this.timer.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upload(BufferedRandomAccessFile bis) throws IOException {
        this.fa = new FtpFISAdapter(bis);
        this.storeSuccess = false;
        this.startTimer();
        try {
            ALog.d((String)this.TAG, (String)String.format("remotePath: %s", this.remotePath));
            this.storeSuccess = this.client.storeFile(this.remotePath, this.fa, new OnFtpInputStreamListener(){
                boolean isStoped = false;

                @Override
                public void onFtpInputStream(FTPClient client, long totalBytesTransferred, int bytesTransferred, long streamSize) {
                    try {
                        FtpUThreadTaskAdapter.this.isTimeOut = false;
                        if (FtpUThreadTaskAdapter.this.getThreadTask().isBreak() && !this.isStoped) {
                            this.isStoped = true;
                            client.abor();
                            return;
                        }
                        if (FtpUThreadTaskAdapter.this.mSpeedBandUtil != null) {
                            FtpUThreadTaskAdapter.this.mSpeedBandUtil.limitNextBytes(bytesTransferred);
                        }
                        FtpUThreadTaskAdapter.this.progress(bytesTransferred);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        FtpUThreadTaskAdapter.this.storeSuccess = false;
                    }
                }
            });
        }
        catch (IOException e) {
            String msg = String.format("\u6587\u4ef6\u4e0a\u4f20\u9519\u8bef\uff0c\u9519\u8bef\u7801\u4e3a\uff1a%s, msg\uff1a%s, filePath: %s", this.client.getReply(), this.client.getReplyString(), this.getEntity().getFilePath());
            e.printStackTrace();
            if (e.getMessage().contains("AriaIOException caught while copying")) {
                e.printStackTrace();
            } else {
                this.fail((AriaException)new AriaFTPException(msg, (Exception)e), !this.storeSuccess);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.fa.close();
        }
        int reply = this.client.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            if (reply != 426) {
                this.fail((AriaException)new AriaFTPException(String.format("\u6587\u4ef6\u4e0a\u4f20\u9519\u8bef\uff0c\u9519\u8bef\u7801\u4e3a\uff1a%s, msg\uff1a%s, filePath: %s", reply, this.client.getReplyString(), this.getEntity().getFilePath())), false);
            }
            this.closeClient(this.client);
            return false;
        }
        return this.storeSuccess;
    }
}

