/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.http;

import com.arialyy.aria.util.ALog;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

@Deprecated
public class ChunkedInputStream
extends InputStream {
    private static final String TAG = "ChunkedInputStream";
    private DataInputStream din;
    private int unreadBytes = 0;
    private byte[] singleByte = new byte[1];
    private boolean endOfData = false;
    private String id;

    public ChunkedInputStream(InputStream in, String id) {
        this.din = new DataInputStream(in);
        this.id = id;
        ALog.d((String)TAG, (String)String.format("Creating chunked input for %s", id));
    }

    @Override
    public void close() throws IOException {
        ALog.d((String)TAG, (String)String.format("%s: Closing chunked input.", this.id));
        this.din.close();
    }

    @Override
    public int read() throws IOException {
        int bytesRead = this.read(this.singleByte, 0, 1);
        return bytesRead == -1 ? -1 : this.singleByte[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = 0;
        if (len < 0) {
            throw new IllegalArgumentException(this.id + ": Negative read length");
        }
        if (len == 0) {
            return 0;
        }
        if (this.unreadBytes == 0) {
            try {
                this.unreadBytes = this.din.readInt();
                ALog.d((String)TAG, (String)String.format("%s: Chunk size %s", this.id, this.unreadBytes));
                if (this.unreadBytes == 0) {
                    ALog.d((String)TAG, (String)String.format("%s: Hit end of data", this.id));
                    this.endOfData = true;
                    return -1;
                }
            }
            catch (IOException err) {
                throw new IOException(this.id + ": Error while attempting to read chunk length", err);
            }
        }
        int bytesToRead = Math.min(len, this.unreadBytes);
        try {
            this.din.readFully(b, off, bytesToRead);
        }
        catch (IOException err) {
            throw new IOException(this.id + ": Error while attempting to read " + bytesToRead + " bytes from current chunk", err);
        }
        this.unreadBytes -= bytesToRead;
        return bytesRead += bytesToRead;
    }

    public boolean isEndOfData() {
        return this.endOfData;
    }
}

