/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.http.download;

import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.common.CompleteInfo;
import com.arialyy.aria.core.download.DGTaskWrapper;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.core.inf.ITaskOption;
import com.arialyy.aria.core.loader.IInfoTask;
import com.arialyy.aria.core.loader.ILoaderVisitor;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.exception.AriaHTTPException;
import com.arialyy.aria.http.HttpTaskOption;
import com.arialyy.aria.http.download.HttpDFileInfoTask;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public final class HttpDGInfoTask
implements IInfoTask {
    private String TAG = CommonUtil.getClassName((Object)this);
    private IInfoTask.Callback callback;
    private DGTaskWrapper wrapper;
    private final Object LOCK = new Object();
    private ExecutorService mPool = null;
    private boolean getLenComplete = false;
    private AtomicInteger count = new AtomicInteger();
    private AtomicInteger failCount = new AtomicInteger();
    private boolean isStop = false;
    private boolean isCancel = false;
    private IInfoTask.Callback subCallback = new IInfoTask.Callback(){

        public void onSucceed(String url, CompleteInfo info) {
            HttpDGInfoTask.this.count.getAndIncrement();
            HttpDGInfoTask.this.checkGetSizeComplete(HttpDGInfoTask.this.count.get(), HttpDGInfoTask.this.failCount.get());
            ALog.d((String)HttpDGInfoTask.this.TAG, (String)"\u83b7\u53d6\u5b50\u4efb\u52a1\u4fe1\u606f\u5b8c\u6210");
        }

        public void onFail(AbsEntity entity, AriaException e, boolean needRetry) {
            ALog.e((String)HttpDGInfoTask.this.TAG, (String)String.format("\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0curl\uff1a%s", ((DownloadEntity)entity).getUrl()));
            HttpDGInfoTask.this.count.getAndIncrement();
            HttpDGInfoTask.this.failCount.getAndIncrement();
            ((DGInfoCallback)HttpDGInfoTask.this.callback).onSubFail((DownloadEntity)entity, new AriaHTTPException(String.format("\u5b50\u4efb\u52a1\u83b7\u53d6\u6587\u4ef6\u957f\u5ea6\u5931\u8d25\uff0curl\uff1a%s", ((DownloadEntity)entity).getUrl())), needRetry);
            HttpDGInfoTask.this.checkGetSizeComplete(HttpDGInfoTask.this.count.get(), HttpDGInfoTask.this.failCount.get());
        }
    };

    HttpDGInfoTask(DGTaskWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void stop() {
        this.isStop = true;
        if (this.mPool != null) {
            this.mPool.shutdown();
        }
    }

    public void cancel() {
        this.isCancel = true;
        if (this.mPool != null) {
            this.mPool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.mPool != null && !this.getLenComplete) {
            ALog.d((String)this.TAG, (String)"\u83b7\u53d6\u957f\u5ea6\u672a\u5b8c\u6210\u7684\u60c5\u51b5\u4e0b\uff0c\u505c\u6b62\u7ec4\u5408\u4efb\u52a1");
            this.mPool.shutdown();
            ((DGInfoCallback)this.callback).onStop(0L);
            return;
        }
        if (this.wrapper.isUnknownSize()) {
            this.mPool = Executors.newCachedThreadPool();
            this.getGroupSize();
            try {
                Object object = this.LOCK;
                synchronized (object) {
                    this.LOCK.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!this.mPool.isShutdown()) {
                this.mPool.shutdown();
            }
        } else {
            for (DTaskWrapper wrapper : this.wrapper.getSubTaskWrapper()) {
                this.cloneHeader(wrapper);
            }
            this.callback.onSucceed(this.wrapper.getKey(), new CompleteInfo());
        }
    }

    private void getGroupSize() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (DTaskWrapper dTaskWrapper : HttpDGInfoTask.this.wrapper.getSubTaskWrapper()) {
                    DownloadEntity subEntity = (DownloadEntity)dTaskWrapper.getEntity();
                    if (subEntity.getFileSize() > 0L) {
                        HttpDGInfoTask.this.count.getAndIncrement();
                        if (subEntity.getCurrentProgress() < subEntity.getFileSize()) {
                            HttpDGInfoTask.this.cloneHeader(dTaskWrapper);
                        }
                        HttpDGInfoTask.this.checkGetSizeComplete(HttpDGInfoTask.this.count.get(), HttpDGInfoTask.this.failCount.get());
                        continue;
                    }
                    HttpDGInfoTask.this.cloneHeader(dTaskWrapper);
                    HttpDFileInfoTask infoTask = new HttpDFileInfoTask(dTaskWrapper);
                    infoTask.setCallback(HttpDGInfoTask.this.subCallback);
                    HttpDGInfoTask.this.mPool.execute(infoTask);
                }
            }
        }).start();
    }

    private void checkGetSizeComplete(int count, int failCount) {
        if (this.isStop || this.isCancel) {
            ALog.w((String)this.TAG, (String)("\u4efb\u52a1\u5df2\u505c\u6b62\u6216\u5df2\u53d6\u6d88\uff0cisStop = " + this.isStop + ", isCancel = " + this.isCancel));
            this.notifyLock();
            return;
        }
        if (failCount == this.wrapper.getSubTaskWrapper().size()) {
            this.callback.onFail(this.wrapper.getEntity(), (AriaException)new AriaHTTPException("\u83b7\u53d6\u5b50\u4efb\u52a1\u957f\u5ea6\u5931\u8d25"), false);
            this.notifyLock();
            return;
        }
        if (count == this.wrapper.getSubTaskWrapper().size()) {
            long size = 0L;
            for (DTaskWrapper wrapper : this.wrapper.getSubTaskWrapper()) {
                size += ((DownloadEntity)wrapper.getEntity()).getFileSize();
            }
            ((DownloadGroupEntity)this.wrapper.getEntity()).setConvertFileSize(CommonUtil.formatFileSize((double)size));
            ((DownloadGroupEntity)this.wrapper.getEntity()).setFileSize(size);
            ((DownloadGroupEntity)this.wrapper.getEntity()).update();
            this.getLenComplete = true;
            ALog.d((String)this.TAG, (String)String.format("\u83b7\u53d6\u7ec4\u5408\u4efb\u52a1\u957f\u5ea6\u5b8c\u6210\uff0c\u7ec4\u5408\u4efb\u52a1\u603b\u957f\u5ea6\uff1a%s\uff0c\u5931\u8d25\u7684\u5b50\u4efb\u52a1\u6570\uff1a%s", size, failCount));
            this.callback.onSucceed(this.wrapper.getKey(), new CompleteInfo());
            this.notifyLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLock() {
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notifyAll();
        }
    }

    private void cloneHeader(DTaskWrapper taskWrapper) {
        HttpTaskOption groupOption = (HttpTaskOption)this.wrapper.getTaskOption();
        HttpTaskOption subOption = new HttpTaskOption();
        subOption.setFileLenAdapter(groupOption.getFileLenAdapter());
        subOption.setFileNameAdapter(groupOption.getFileNameAdapter());
        subOption.setUseServerFileName(groupOption.isUseServerFileName());
        subOption.setFileNameAdapter(groupOption.getFileNameAdapter());
        subOption.setRequestEnum(groupOption.getRequestEnum());
        subOption.setHeaders(groupOption.getHeaders());
        subOption.setProxy(groupOption.getProxy());
        subOption.setParams(groupOption.getParams());
        taskWrapper.setTaskOption((ITaskOption)subOption);
    }

    public void setCallback(IInfoTask.Callback callback) {
        this.callback = callback;
    }

    public void accept(ILoaderVisitor visitor) {
        visitor.addComponent((IInfoTask)this);
    }

    public static interface DGInfoCallback
    extends IInfoTask.Callback {
        public void onSubFail(DownloadEntity var1, AriaHTTPException var2, boolean var3);

        public void onStop(long var1);
    }
}

