/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.m3u8;

import android.text.TextUtils;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.M3U8Entity;
import com.arialyy.aria.core.listener.IEventListener;
import com.arialyy.aria.core.loader.AbsNormalLoader;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.m3u8.M3U8TaskOption;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public abstract class BaseM3U8Loader
extends AbsNormalLoader<DTaskWrapper> {
    protected M3U8TaskOption mM3U8Option;

    public BaseM3U8Loader(DTaskWrapper wrapper, IEventListener listener) {
        super((AbsTaskWrapper)wrapper, listener);
        this.mM3U8Option = (M3U8TaskOption)wrapper.getM3u8Option();
        this.mTempFile = new File(((DownloadEntity)wrapper.getEntity()).getFilePath());
    }

    protected long delayTimer() {
        return 1000L;
    }

    public static String getTsFilePath(String dirCache, int threadId) {
        return String.format("%s/%s.ts", dirCache, threadId);
    }

    public String getCacheDir() {
        String cacheDir = this.mM3U8Option.getCacheDir();
        if (TextUtils.isEmpty((CharSequence)cacheDir)) {
            cacheDir = FileUtil.getTsCacheDir((String)this.getEntity().getFilePath(), (int)this.mM3U8Option.getBandWidth());
        }
        if (!new File(cacheDir).exists()) {
            FileUtil.createDir((String)cacheDir);
        }
        return cacheDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generateIndexFile(boolean isLive) {
        File tempFile = new File(String.format("%s.index", this.getEntity().getFilePath()));
        if (!tempFile.exists()) {
            ALog.e((String)this.TAG, (String)"\u6e90\u7d22\u5f15\u6587\u4ef6\u4e0d\u5b58\u5728");
            return false;
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            String line;
            String cacheDir = this.getCacheDir();
            fis = new FileInputStream(tempFile);
            fos = new FileOutputStream(this.getEntity().getFilePath());
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            int i = 0;
            while ((line = reader.readLine()) != null) {
                byte[] bytes;
                if (line.startsWith("#EXTINF")) {
                    fos.write(line.concat("\r\n").getBytes(Charset.forName("UTF-8")));
                    String tsPath = BaseM3U8Loader.getTsFilePath(cacheDir, ((ThreadRecord)this.mRecord.threadRecords.get((int)i)).threadId);
                    bytes = tsPath.concat("\r\n").getBytes(Charset.forName("UTF-8"));
                    reader.readLine();
                    ++i;
                } else if (line.startsWith("#EXT-X-KEY")) {
                    M3U8Entity m3U8Entity = this.getEntity().getM3U8Entity();
                    StringBuilder sb = new StringBuilder("#EXT-X-KEY:");
                    sb.append("METHOD=").append(m3U8Entity.method);
                    sb.append(",URI=\"").append(m3U8Entity.keyPath).append("\"");
                    if (!TextUtils.isEmpty((CharSequence)m3U8Entity.iv)) {
                        sb.append(",IV=").append(m3U8Entity.iv);
                    }
                    if (!TextUtils.isEmpty((CharSequence)m3U8Entity.keyFormat)) {
                        sb.append(",KEYFORMAT=\"").append(m3U8Entity.keyFormat).append("\"");
                        sb.append(",KEYFORMATVERSIONS=\"").append(TextUtils.isEmpty((CharSequence)m3U8Entity.keyFormatVersion) ? "1" : m3U8Entity.keyFormatVersion).append("\"");
                    }
                    sb.append("\r\n");
                    bytes = sb.toString().getBytes(Charset.forName("UTF-8"));
                } else {
                    bytes = line.concat("\r\n").getBytes(Charset.forName("UTF-8"));
                }
                fos.write(bytes, 0, bytes.length);
            }
            if (isLive) {
                fos.write("#EXT-X-ENDLIST".concat("\r\n").getBytes(Charset.forName("UTF-8")));
            }
            fos.flush();
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (tempFile.exists()) {
                    FileUtil.deleteFile((File)tempFile);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public long getCurrentProgress() {
        return this.isRunning() ? this.getStateManager().getCurrentProgress() : this.getEntity().getCurrentProgress();
    }

    protected DownloadEntity getEntity() {
        return (DownloadEntity)((DTaskWrapper)this.mTaskWrapper).getEntity();
    }
}

