/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.m3u8;

import android.net.TrafficStats;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.common.CompleteInfo;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.M3U8Entity;
import com.arialyy.aria.core.loader.IInfoTask;
import com.arialyy.aria.core.loader.ILoaderVisitor;
import com.arialyy.aria.core.processor.IKeyUrlConverter;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.exception.AriaM3U8Exception;
import com.arialyy.aria.http.ConnectionHelp;
import com.arialyy.aria.http.HttpTaskOption;
import com.arialyy.aria.m3u8.BandWidthDefConverter;
import com.arialyy.aria.m3u8.M3U8TaskOption;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CheckUtil;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class M3U8InfoTask
implements IInfoTask {
    public static final String M3U8_INDEX_FORMAT = "%s.index";
    private final String TAG = "M3U8InfoThread";
    private DownloadEntity mEntity;
    private DTaskWrapper mTaskWrapper;
    private int mConnectTimeOut;
    private OnGetLivePeerCallback onGetPeerCallback;
    private HttpTaskOption mHttpOption;
    private M3U8TaskOption mM3U8Option;
    private IInfoTask.Callback mCallback;
    private boolean isStop = false;

    public void accept(ILoaderVisitor visitor) {
        visitor.addComponent((IInfoTask)this);
    }

    public M3U8InfoTask(DTaskWrapper taskWrapper) {
        this.mTaskWrapper = taskWrapper;
        this.mEntity = (DownloadEntity)taskWrapper.getEntity();
        this.mConnectTimeOut = AriaConfig.getInstance().getDConfig().getConnectTimeOut();
        this.mHttpOption = (HttpTaskOption)taskWrapper.getTaskOption();
        this.mM3U8Option = (M3U8TaskOption)taskWrapper.getM3u8Option();
        this.mEntity.getM3U8Entity().setLive(this.mTaskWrapper.getRequestType() == 8);
    }

    public void run() {
        Process.setThreadPriority((int)10);
        TrafficStats.setThreadStatsTag((int)UUID.randomUUID().toString().hashCode());
        HttpURLConnection conn = null;
        try {
            URL url = ConnectionHelp.handleUrl((String)this.mEntity.getUrl(), (HttpTaskOption)this.mHttpOption);
            conn = ConnectionHelp.handleConnection((URL)url, (HttpTaskOption)this.mHttpOption);
            ConnectionHelp.setConnectParam((HttpTaskOption)this.mHttpOption, (HttpURLConnection)conn);
            conn.setConnectTimeout(this.mConnectTimeOut);
            conn.connect();
            this.handleConnect(this.mEntity.getUrl(), conn);
        }
        catch (IOException e) {
            this.failDownload(e.getMessage(), false);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public void setCallback(IInfoTask.Callback callback) {
        this.mCallback = callback;
    }

    public void stop() {
        this.isStop = true;
    }

    public void cancel() {
        this.isStop = true;
    }

    private void handleConnect(String tsListUrl, HttpURLConnection conn) throws IOException {
        int code = conn.getResponseCode();
        if (code == 200) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(ConnectionHelp.convertInputStream((HttpURLConnection)conn)));
            String line = reader.readLine();
            if (TextUtils.isEmpty((CharSequence)line) || !line.equalsIgnoreCase("#EXTM3U")) {
                this.failDownload("\u8bfb\u53d6M3U8\u4fe1\u606f\u5931\u8d25\uff0c\u8bfb\u53d6\u4e0d\u5230#EXTM3U\u6807\u7b7e", false);
                return;
            }
            ArrayList<String> extInf = new ArrayList<String>();
            boolean isLive = this.mTaskWrapper.getRequestType() == 8;
            boolean isGenerateIndexFile = ((M3U8TaskOption)this.mTaskWrapper.getM3u8Option()).isGenerateIndexFile();
            FileOutputStream fos = null;
            if (isGenerateIndexFile) {
                String indexPath = String.format(M3U8_INDEX_FORMAT, this.mEntity.getFilePath());
                File indexFile = new File(indexPath);
                if (!indexFile.exists()) {
                    FileUtil.createFile((String)indexPath);
                }
                fos = new FileOutputStream(indexFile);
                ALog.d((String)"M3U8InfoThread", (String)line);
                this.addIndexInfo(true, fos, line);
            }
            while ((line = reader.readLine()) != null && !this.isStop) {
                ALog.d((String)"M3U8InfoThread", (String)line);
                if (line.startsWith("#EXT-X-ENDLIST")) {
                    this.addIndexInfo(isGenerateIndexFile && !isLive, fos, line);
                    break;
                }
                if (line.startsWith("#EXTINF")) {
                    String url = reader.readLine();
                    if (isLive) {
                        if (this.onGetPeerCallback != null) {
                            this.onGetPeerCallback.onGetPeer(url, line);
                        }
                    } else {
                        extInf.add(url);
                    }
                    ALog.d((String)"M3U8InfoThread", (String)url);
                    this.addIndexInfo(isGenerateIndexFile && !isLive, fos, line);
                    this.addIndexInfo(isGenerateIndexFile && !isLive, fos, url);
                    continue;
                }
                if (line.startsWith("#EXT-X-STREAM-INF")) {
                    this.addIndexInfo(isGenerateIndexFile, fos, line);
                    int setBand = this.mM3U8Option.getBandWidth();
                    int bandWidth = this.getBandWidth(line);
                    if (setBand == 0) {
                        this.handleBandWidth(conn, reader.readLine());
                    } else if (bandWidth == setBand) {
                        this.handleBandWidth(conn, reader.readLine());
                    } else {
                        this.failDownload(String.format("\u3010%s\u3011\u7801\u7387\u4e0d\u5b58\u5728", setBand), false);
                    }
                    return;
                }
                if (line.startsWith("#EXT-X-KEY")) {
                    this.addIndexInfo(isGenerateIndexFile, fos, line);
                    this.getKeyInfo(tsListUrl, line);
                    continue;
                }
                this.addIndexInfo(isGenerateIndexFile, fos, line);
            }
            if (!isLive && extInf.isEmpty()) {
                this.failDownload(String.format("\u83b7\u53d6M3U8\u4e0b\u8f7d\u5730\u5740\u5217\u8868\u5931\u8d25\uff0curl: %s", this.mEntity.getUrl()), false);
                return;
            }
            if (!isLive && this.mEntity.getM3U8Entity().getPeerNum() == 0) {
                this.mEntity.getM3U8Entity().setPeerNum(extInf.size());
                this.mEntity.getM3U8Entity().update();
            }
            CompleteInfo info = new CompleteInfo();
            info.obj = extInf;
            this.onSucceed(info);
            if (fos != null) {
                fos.close();
            }
        } else if (code == 302 || code == 301 || code == 303 || code == 201 || code == 307) {
            this.handleUrlReTurn(conn, conn.getHeaderField("Location"));
        } else if (code >= 400) {
            this.failDownload("\u4e0b\u8f7d\u5931\u8d25\u9519\u8bef\uff0c\u9519\u8bef\u7801\uff1a" + code, false);
        } else {
            this.failDownload(String.format("\u4e0d\u652f\u6301\u7684\u54cd\u5e94\uff0ccode: %s", code), true);
        }
    }

    private void onSucceed(CompleteInfo info) {
        if (this.isStop) {
            return;
        }
        this.mCallback.onSucceed(this.mEntity.getKey(), info);
    }

    private void addIndexInfo(boolean write, FileOutputStream fos, String info) throws IOException {
        if (!write) {
            return;
        }
        fos.write(info.concat("\r\n").getBytes(Charset.forName("UTF-8")));
    }

    public void setStop(boolean isStop) {
        this.isStop = isStop;
    }

    public void setOnGetPeerCallback(OnGetLivePeerCallback peerCallback) {
        this.onGetPeerCallback = peerCallback;
    }

    private void getKeyInfo(String tsListUrl, String line) {
        String temp = line.substring(line.indexOf(":") + 1);
        String[] params = temp.split(",");
        M3U8Entity m3U8Entity = this.mEntity.getM3U8Entity();
        for (String param : params) {
            if (param.startsWith("METHOD")) {
                m3U8Entity.method = param.split("=")[1];
                continue;
            }
            if (param.startsWith("URI")) {
                m3U8Entity.keyUrl = param.split("=")[1].replaceAll("\"", "");
                String keyPath = ((M3U8TaskOption)this.mTaskWrapper.getM3u8Option()).getKeyPath() == null ? new File(this.mEntity.getFilePath()).getParent() + "/" + CommonUtil.getStrMd5((String)m3U8Entity.keyUrl) + ".key" : ((M3U8TaskOption)this.mTaskWrapper.getM3u8Option()).getKeyPath();
                m3U8Entity.keyPath = keyPath;
                continue;
            }
            if (param.startsWith("IV")) {
                m3U8Entity.iv = param.split("=")[1];
                continue;
            }
            if (param.startsWith("KEYFORMAT")) {
                m3U8Entity.keyFormat = param.split("=")[1];
                continue;
            }
            if (!param.startsWith("KEYFORMATVERSIONS")) continue;
            m3U8Entity.keyFormatVersion = param.split("=")[1];
        }
        this.downloadKey(tsListUrl, m3U8Entity);
    }

    private int getBandWidth(String line) {
        Pattern p = Pattern.compile("[0-9]{3,}");
        Matcher m = p.matcher(line);
        if (m.find()) {
            return Integer.parseInt(m.group());
        }
        return 0;
    }

    private void handleUrlReTurn(HttpURLConnection conn, String newUrl) throws IOException {
        ALog.d((String)"M3U8InfoThread", (String)("30x\u8df3\u8f6c\uff0c\u65b0url\u4e3a\u3010" + newUrl + "\u3011"));
        if (TextUtils.isEmpty((CharSequence)newUrl) || newUrl.equalsIgnoreCase("null")) {
            if (this.mCallback != null) {
                this.mCallback.onFail((AbsEntity)this.mEntity, (AriaException)new AriaM3U8Exception("\u83b7\u53d6\u91cd\u5b9a\u5411\u94fe\u63a5\u5931\u8d25"), false);
            }
            return;
        }
        if (newUrl.startsWith("/")) {
            Uri uri = Uri.parse((String)this.mEntity.getUrl());
            newUrl = uri.getHost() + newUrl;
        }
        if (!CheckUtil.checkUrl((String)newUrl)) {
            this.failDownload("\u4e0b\u8f7d\u5931\u8d25\uff0c\u91cd\u5b9a\u5411url\u9519\u8bef", false);
            return;
        }
        this.mHttpOption.setRedirectUrl(newUrl);
        this.mEntity.setRedirect(true);
        this.mEntity.setRedirectUrl(newUrl);
        String cookies = conn.getHeaderField("Set-Cookie");
        conn.disconnect();
        URL url = ConnectionHelp.handleUrl((String)newUrl, (HttpTaskOption)this.mHttpOption);
        conn = ConnectionHelp.handleConnection((URL)url, (HttpTaskOption)this.mHttpOption);
        ConnectionHelp.setConnectParam((HttpTaskOption)this.mHttpOption, (HttpURLConnection)conn);
        conn.setRequestProperty("Cookie", cookies);
        conn.setConnectTimeout(this.mConnectTimeOut);
        conn.connect();
        this.handleConnect(newUrl, conn);
        conn.disconnect();
    }

    private void handleBandWidth(HttpURLConnection conn, String bandWidthM3u8Url) throws IOException {
        BandWidthDefConverter converter;
        BandWidthDefConverter bandWidthDefConverter = converter = this.mM3U8Option.isUseDefConvert() ? new BandWidthDefConverter() : this.mM3U8Option.getBandWidthUrlConverter();
        if (converter != null) {
            bandWidthM3u8Url = converter.convert(this.mEntity.getUrl(), bandWidthM3u8Url);
            if (!bandWidthM3u8Url.startsWith("http")) {
                this.failDownload(String.format("\u7801\u7387\u8f6c\u6362\u5668\u8f6c\u6362\u540e\u7684url\u5730\u5740\u65e0\u6548\uff0c\u8f6c\u6362\u540e\u7684url\uff1a%s", bandWidthM3u8Url), false);
                return;
            }
        } else {
            ALog.d((String)"M3U8InfoThread", (String)"\u6ca1\u6709\u8bbe\u7f6e\u7801\u7387\u8f6c\u6362\u5668");
        }
        this.mM3U8Option.setBandWidthUrl(bandWidthM3u8Url);
        ALog.d((String)"M3U8InfoThread", (String)String.format("\u65b0\u7801\u7387url\uff1a%s", bandWidthM3u8Url));
        String cookies = conn.getHeaderField("Set-Cookie");
        conn.disconnect();
        URL url = ConnectionHelp.handleUrl((String)bandWidthM3u8Url, (HttpTaskOption)this.mHttpOption);
        conn = ConnectionHelp.handleConnection((URL)url, (HttpTaskOption)this.mHttpOption);
        ConnectionHelp.setConnectParam((HttpTaskOption)this.mHttpOption, (HttpURLConnection)conn);
        conn.setRequestProperty("Cookie", cookies);
        conn.setConnectTimeout(this.mConnectTimeOut);
        conn.connect();
        this.handleConnect(bandWidthM3u8Url, conn);
        conn.disconnect();
    }

    private void failDownload(String errorInfo, boolean needRetry) {
        if (this.isStop) {
            return;
        }
        this.mCallback.onFail((AbsEntity)this.mEntity, (AriaException)new AriaM3U8Exception(errorInfo), needRetry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadKey(String tsListUr, M3U8Entity info) {
        HttpURLConnection conn = null;
        FileOutputStream fos = null;
        try {
            int len;
            File keyF = new File(info.keyPath);
            if (keyF.exists()) {
                return;
            }
            ALog.d((String)"M3U8InfoThread", (String)"\u5bc6\u94a5\u4e0d\u5b58\u5728\uff0c\u4e0b\u8f7d\u5bc6\u94a5");
            FileUtil.createFile((File)keyF);
            IKeyUrlConverter keyUrlConverter = this.mM3U8Option.getKeyUrlConverter();
            String keyUrl = info.keyUrl;
            if (keyUrlConverter != null) {
                keyUrl = keyUrlConverter.convert(this.mEntity.getUrl(), tsListUr, keyUrl);
            }
            if (TextUtils.isEmpty((CharSequence)keyUrl)) {
                ALog.e((String)"M3U8InfoThread", (String)"m3u8\u5bc6\u94a5key url \u4e3a\u7a7a");
                return;
            }
            URL url = ConnectionHelp.handleUrl((String)keyUrl, (HttpTaskOption)this.mHttpOption);
            conn = ConnectionHelp.handleConnection((URL)url, (HttpTaskOption)this.mHttpOption);
            ConnectionHelp.setConnectParam((HttpTaskOption)this.mHttpOption, (HttpURLConnection)conn);
            conn.setConnectTimeout(this.mConnectTimeOut);
            conn.connect();
            InputStream is = ConnectionHelp.convertInputStream((HttpURLConnection)conn);
            fos = new FileOutputStream(keyF);
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface OnGetLivePeerCallback {
        public void onGetPeer(String var1, String var2);
    }
}

