/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.m3u8;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.arialyy.aria.core.listener.BaseListener;
import com.arialyy.aria.core.listener.IDLoadListener;
import com.arialyy.aria.core.task.DownloadTask;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.DeleteM3u8Record;

public final class M3U8Listener
extends BaseListener
implements IDLoadListener {
    public void onPostPre(long fileSize) {
        this.mEntity.setFileSize(fileSize);
        this.mEntity.setConvertFileSize(CommonUtil.formatFileSize((double)fileSize));
        this.saveData(6, -1L);
        this.sendInState2Target(1);
    }

    public void supportBreakpoint(boolean support) {
        if (!support) {
            this.sendInState2Target(9);
        }
    }

    public void onPeerStart(String m3u8Url, String peerPath, int peerIndex) {
        this.sendPeerStateToTarget(177, m3u8Url, peerPath, peerIndex);
    }

    public void onPeerComplete(String m3u8Url, String peerPath, int peerIndex) {
        this.sendPeerStateToTarget(178, m3u8Url, peerPath, peerIndex);
    }

    public void onPeerFail(String m3u8Url, String peerPath, int peerIndex) {
        this.sendPeerStateToTarget(179, m3u8Url, peerPath, peerIndex);
    }

    private void sendPeerStateToTarget(int state, String m3u8Url, String peerPath, int peerIndex) {
        Bundle bundle = new Bundle();
        bundle.putString("DATA_M3U8_URL", m3u8Url);
        bundle.putString("DATA_M3U8_PEER_PATH", peerPath);
        bundle.putInt("DATA_M3U8_PEER_INDEX", peerIndex);
        Message msg = ((Handler)this.outHandler.get()).obtainMessage();
        msg.setData(bundle);
        msg.what = state;
        msg.arg1 = 210;
        msg.sendToTarget();
    }

    protected void handleCancel() {
        int sType = ((DownloadTask)this.getTask(DownloadTask.class)).getSchedulerType();
        if (sType == 4) {
            this.mEntity.setComplete(false);
            this.mEntity.setState(3);
            DeleteM3u8Record.getInstance().deleteRecord(this.mEntity, this.mTaskWrapper.isRemoveFile(), false);
        } else {
            DeleteM3u8Record.getInstance().deleteRecord(this.mEntity, this.mTaskWrapper.isRemoveFile(), true);
        }
    }
}

